<?php
namespace App\Helpers;
/**
 * Created by PhpStorm.
 * User: hp
 * Date: 26/6/19
 * Time: 2:29 PM
 */

/*use App\Models\OtherLeads;
use App\modules\backend\cms\Models\MotorLeadsParents;
use  App\modules\frontend\marketing\Controllers\LeadCreationController;
use App\modules\frontend\search\Models\TermLeadsParents;
use App\modules\frontend\search\Models\HealthLeadsParents;
use App\modules\frontend\search\Models\UlipLeadsParents;
use App\modules\frontend\marketing\Controllers\LeadCreationOthersController;
*/
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cache;
use App\modules\backend\cms\Models\LmsStatus;
use Carbon\Carbon;

class  LeadsHelper{

    const CACHE_KEY = 'OtherOperationsController';

    public static function getStatus()
    {
        $all = [];
        $cachekey = self::CACHE_KEY . 'getStatus12';
        if (Cache::has($cachekey)) {
            $all = Cache::get($cachekey);
        } else {
            $status = LmsStatus::wherein('status_group', ['lms_operations', 'operation_sub_status', 'lms_operations_dttm'])->get();
            foreach ($status as $statu) {
                $s[$statu->status_id] = $statu->name;
            }
            $all['s'] = $s;
            $all['status'] = $status;
            $expiresAt = Carbon::now()->addMinutes(100000);
            Cache::put($cachekey, $all, $expiresAt);
        }
        return $all;
    }

    public static function lmsStatus()
    {
        $cache_key = self::CACHE_KEY . 'lmsStatus';
        if (Cache::has($cache_key)) {
            $statusArray = Cache::get($cache_key);
        } else {
            $lmsStatus = LmsStatus::orderby('name', 'ASC')->get();
            $statusArray = [];
            foreach ($lmsStatus as $status) {
                $statusArray[$status->status_id] = $status;
            }
            $expiresAt = Carbon::now()->addMinutes(1440);
            Cache::put($cache_key, $statusArray, $expiresAt);
        }
        return $statusArray;
    }


    public static function getUser()
    {
        $all = [];
        $cachekey = self::CACHE_KEY . 'getUser2';
        if (Cache::has($cachekey)) {
            $all = Cache::get($cachekey);
        } else {
            $users = Admin::wherein('role', Config::get('app.motor_lms_operations_role'))->where(['status' => 'Active'])->get();
            foreach ($users as $user) {
                $u[$user->id] = $user->name;
            }
            $all['users'] = $users;
            $all['u'] = $u;
            $expiresAt = Carbon::now()->addMinutes(100);
            Cache::put($cachekey, $all, $expiresAt);
        }
        return $all;
    }

    public static function getCompanies()
    {
        $cachekey = self::CACHE_KEY . 'getCompanies2';
        if (Cache::has($cachekey)) {
            $companies = Cache::get($cachekey);
        } else {
            $companies = Companies::select(['company_id', 'company_name'])
                ->where(['status' => 'Active'])
                ->where(['insurance_type' => 2])
                ->get();
            $expiresAt = Carbon::now()->addMinutes(10000);
            Cache::put($cachekey, $companies, $expiresAt);
        }
        return $companies;
    }

    public static function getCompaniesNameVsId($id = "")
    {
        //echo "===".$id."===";
        $companies = self::getCompanies();
        $cachekey = self::CACHE_KEY . 'getCompaniesNameVsId2';
        if (Cache::has($cachekey)) {
            $arr = Cache::get($cachekey);
        } else {
            $arr = [];
            foreach ($companies as $id => $company) {
                $key = slugify($company->company_name);
                $arr[$key] = $company;
            }
            $expiresAt = Carbon::now()->addMinutes(10000);
            Cache::put($cachekey, $arr, $expiresAt);
        }

        if (isset($id) && $id != "") {
            return $arr[$id];
        }
        return $arr;
    }


    public function getLeadId($response, $insurance_type)
    {
        $lead_id = "";
        if ($insurance_type == "term") {
            $lead_id = $response['inputs']['term_parent_lead_id'];
            $Parents = TermLeadsParents::find($lead_id);
        } elseif ($insurance_type == "health") {
            $lead_id = $response['inputs']['health_parent_lead_id'];
            $Parents = HealthLeadsParents::find($lead_id);
        } elseif ($insurance_type == "investment") {
            $lead_id = $response['inputs']['ulip_parent_lead_id'];
            $Parents = UlipLeadsParents::find($lead_id);
        }elseif (in_array($insurance_type,["car","cveh","bike","others"])) {
            $lead_id = $response['inputs']['lead_id'];
            $Parents = OtherLeads::find($lead_id);
            $Parents->hierarchy = '|1067|1066|808|';
            $Parents->agent_id = 1067;
            $Parents->save();
        }
        return $lead_id;
    }

    public function getProduct($insurance_type)
    {
        if ($insurance_type == "Term") {
            $product = "term";
        } elseif ($insurance_type == "Health") {
            $product = "health";
        }elseif ($insurance_type == "Travel") {
            $product = "travel";
        } elseif ($insurance_type == "Investment" || $insurance_type == "Retirement") {
            $product = "investment";
        }elseif ($insurance_type == "Car") {
            $product = "car";
        }elseif ($insurance_type == "Commercial Vehicle") {
            $product = "cveh";
        }elseif ($insurance_type == "Bike") {
            $product = "bike";
        }else{
            $product = "others";
        }
        return $product;
    }
}