<?php


namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Str;
use Northwestern\SysDev\DynamicForms\ResourceRegistry;
use Northwestern\SysDev\DynamicForms\Resources\ResourceInterface;
use Symfony\Component\Finder\Finder;

class DynamicFormsResourceController extends Controller
{
    
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Provides the index of all registered Resources
     *
     * @return \Illuminate\Http\Response
     */
    public function index(ResourceRegistry $resourceRegistry) //register
    {
        $resourceIndexList = array_keys($resourceRegistry->registered());

        $resources = [];
        foreach ($resourceIndexList as $resourceName) {
            $resources[] = [
                '_id' => $resourceName,
                'title' => $resourceName
            ];
        }

        $retString = json_encode($resources);

        return response(
            $retString
        ) ->header('Content-Type', 'application/json');
    }

    /**
     * Returns a description of components for the given Resource
     *
     * @return \Illuminate\Http\Response
     */
    public function resource($resource, ResourceRegistry $resourceRegistry)
    {
        $resourceList = $resourceRegistry->registered();
        if(!isset($resourceList[$resource]))
        {
            abort(404, 'Given Resource does not exist');
        }
        $componentList = json_encode($resourceList[$resource]::components());
        $str = '{"type":"resource", "components": '.$componentList.'}';
        return response($str)->header('Content-Type', 'application/json');
    }

    /**
     * Returns the submission values for a given resource
     *
     * @return \Illuminate\Http\Response
     */
    public function resourceSubmissions(Request $request, $resource, ResourceRegistry $resourceRegistry)
    {
        $resourceList = $resourceRegistry->registered();
        if(!isset($resourceList[$resource]))
        {
            abort(404, 'Given Resource does not exist');
        }
        $params = $request->query();
        $limit = $params['limit'];
        $skip = $params['skip'];
        $searchKey = '';
        $searchValue = '';
        foreach ($params as $key => $value) {
            if (str_starts_with($key, 'data')) {
                if($key !== 'data__regex' && preg_match('/data_(.*)__regex/', $key, $match))
                {
                    $searchKey = $match[1];
                }
                $searchValue = $value;
                break;
            }
        }
        $resourceSubmissions = $resourceList[$resource]::submissions($limit, $skip, $searchKey, $searchValue);
        $handlesPaginationAndSearch = $resourceList[$resource]::handlesPaginationAndSearch();

        if(!$handlesPaginationAndSearch)
        {
            if($searchValue !== '')
            {
                $resourceSubmissions = array_filter($resourceSubmissions, function ($submissions) use ($limit, $skip, $searchKey, $searchValue) {
                    foreach ($submissions as $submissionComponent => $submissionValue)
                    {
                        if(($searchKey === '' || $submissionComponent === $searchKey) && str_contains($submissionValue, $searchValue) )
                        {
                            return true;
                        }
                    }
                    return false;
                } );
            }

            $resourceSubmissions = array_slice($resourceSubmissions, $skip, $limit);
        }

        $count = 0;
        $submissions = [];
        foreach ($resourceSubmissions as $componentName => $submission) {
            foreach ($submission as $label => $value) {
                $submissions[] = [
                    '_id' => $componentName.$count,
                    'roles' => [],
                    'state' => 'submitted',
                    'access' => [],
                    'data' => [
                        'label-'.$componentName => $label,
                        'value' => $value
                    ]
                ];
                $count++;
            }

        }
        $str = json_encode($submissions);

        return response($str)->header('Content-Type', 'application/json');
    }
}
