<?php namespace App\Modules;

use App\Models\Admin;
use Illuminate\Support\Facades\View;
use DB;
use App\Helpers\FreshLeadCountHelper;

class ServiceProvider extends \Illuminate\Support\ServiceProvider
{

    public function boot()
    {
        $modules = config("module.modules");

        $backendmodules = $modules['backend'];
        // backend modules registeration
        foreach ($backendmodules as $module) {
            if (file_exists(__DIR__ . '/backend/' . $module . '/routes.php')) {
                include __DIR__ . '/backend/' . $module . '/routes.php';
            }
            if (is_dir(__DIR__ . '/backend/' . $module . '/Views')) {
                $this->loadViewsFrom(__DIR__ . '/backend/' . $module . '/Views', $module);
            }
        }

    }

    public function register()
    {
    }

}