<?php

namespace App\modules\backend\cms\Controllers;

use App\Helpers\LeadsHelper;
use App\Http\Controllers\Controller;
use App\modules\backend\cms\Models\LmsStatus;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Maatwebsite\Excel\Facades\Excel;
use Carbon\Carbon;
use App\modules\backend\cms\Models\AllLeads;
use App\Helpers\TeamHelper;
use App\modules\backend\cms\Models\Lmsassignhistory;

/**
 * File: OperationsController.php
 * Date: 8/29/2016
 * Time: 5:27 PM
 * Author: Mohammad Arshi
 * Email: Mohammad Arshi
 */
class LifeLeadsController extends Controller
{
    public $utm;
    const CACHE_KEY = 'OtherOperationsController';

    public function __construct()
    {

        $this->middleware('permission:lead_life');

        $this->product_type = ['other-car' => 'car', 'other-bike' => 'bike', 'cveh' => 'cveh', 'travel' => 'travel', 'others' => 'other', 'other-all' => ''];
    }


    public function getSubStatus()
    {
        $id = request()->get('status_id');
        request()->get('asddas');
        $stlist = '';
        if (!empty($id)) {
            $statuslist = LmsStatus::where('parent_status', $id)->get();
            //echo '<pre>';print_r($statuslist); die;
            if (!empty($statuslist)) {
                foreach ($statuslist as $status) {
                    # code...
                    $stlist .= '<option value="' . $status->status_id . '">' . $status->name . '</option>';
                }
            }


        }
        echo $stlist;
    }

    public function updateLeadOperationStatus()
    {
        checkUserCapablities(['operations_change_status_buttons']);
        if (is_array(request()->get('operation_id'))) {
            foreach (request()->get('operation_id') as $operation_id) {
                $operation = MotorLmsOperation::find($operation_id);
                $operation->{request()->get('status')} = 1;
                $operation->save();
            }
        } else {
            $operation = MotorLmsOperation::find(request()->get('operation_id'));
            $operation->{request()->get('status')} = 1;
            $operation->save();
        }
        return ['status' => 1, 'message' => 'success'];
    }

    public function import()
    {
        $file = Input::file('bookingfile');
        $error = [];
        $count = 0;
        $company = self::getCompanies();
        $company = $company->toArray();
        $status = self::getStatus();
        $sub_status = self::getSubStatus();
        if (!empty($file)) {
            $import_storage = $file->move(storage_path() . '/import/', date('Ymd') . '_' . date('His') . '_' . str_random(5) . '_' . $file->getClientOriginalName());
            Excel::load($import_storage, function ($reader) use (&$error, &$count, $company) {
                $reader->each(function ($row) use (&$error, &$count, $company) {
                    $row = $row->toArray();
                    $toSave = self::sanitizeData($row);
                    //pr($toSave);die;
                    if (isset($toSave['product']) && $toSave['product'] != "") {
                        //pr($toSave);die;
                        $lead = self::createLead($toSave);
                        $toSave['lead_id'] = $lead->id;
                        $operation = self::createBooking($toSave);
                        $toSave['operation_id'] = $operation->id;
                        $toSave['operation_status'] = $operation->status;
                        self::createActionHistory($toSave);
                        $count++;
                        //pr($toSave);die;
                    }
                });
            });
        }
        \Session::flash('message', 'Import Successfull! ' . $count . ' Rows Inserted.');
        return Redirect::back()
            ->with('error', $error);
    }

    public function getPreviousInsurers()
    {
        $insurers = [];
        if (Input::has('company_id') && request()->get('company_id') == 63) {
            $insurers = DB::table('raw_kotak_insurers')->select('insurer_name')->orderBy('insurer_name', 'ASC')->get();
        } elseif (Input::has('company_id') && request()->get('company_id') == 37) {
            $insurers = DB::table('raw_hdfc_insurer_list')->select('InsurerName as insurer_name')->where('status', '=', 1)->orderBy('InsurerName', 'ASC')->get();
        }

        return ['status' => 1, 'message' => 'success', 'insurers' => $insurers];
    }

    public function getLeads()
    {
        global $memberTree;
        $selectedId = "";
        $selectedName = "";
        $this->currentUser = auth()->user();
        $leads = $this->getLeadsOthers();
        //print_r($leads);die;
        $lmsStatus = LeadsHelper::lmsStatus();
        $statusArray = [];
        foreach ($lmsStatus as $status_id => $status_name) {
            $statusArray[$status_id] = $status_name->name;
        }
        $canSeeFull = canSeeFullHierarchy($this->currentUser->role_id);
        $teamMember = TeamHelper::getTeamMember($canSeeFull);
        $allUsers = [];
        $u = [];
        foreach ($teamMember as $user_id => $item) {
            $allUsers[$user_id] = $item;
            $u[] = ['label' => $item, 'value' => $user_id];
            if ($user_id == request()->get('uid')) {
                $selectedId = $user_id;
                $selectedName = $item;
            }
        }

        $this->currentLeadType = 1;
        $leads = $leads->paginate(20);
        $leads->setPath('health-leads');
        $route = "life";
        return view('cms::leads.health-leads-listing')->with(['leadslist' => $leads, 'lmsstatus' => $lmsStatus, 'users' => $allUsers, 'activeUsers' => $u, 'current_lead_type' => $this->currentLeadType, 'status_array' => $statusArray, 'manage_status' => $lmsStatus, 'selectedName' => $selectedName, 'selectedId' => $selectedId,'route'=>$route]);
    }

    public function getLeadsOthers()
    {
        $product = 'term';
        $called_date_range = request()->get('called_date_range');
        $q = request()->get('q');
        $uid = request()->get('uid');
        $lead_action = request()->get('lead_action');
        $data = new AllLeads;

        if (isset($product) && $product != "") {
            $product_code = $product;
            $data = $data->where('product', '=', $product_code);
        }

        if (isset($lead_action) && $lead_action != "") {
            $data = $data->where('status', '=', $lead_action);
        }

        /*if (canSeeFullHierarchy($this->currentUser->role_id)) {
            if (isset($uid) && $uid != "") {
                $data = $data->where('hierarchy', 'LIKE', "%|$uid|%");
            }
        } else {
            if (isset($uid) && $uid != "") {
                $data = $data->where('hierarchy', 'LIKE', "%|$uid|%");
                $data = $data->where('hierarchy', 'LIKE', "%|" . $this->currentUser->id . "|%");
            } else {
                $data = $data->where('hierarchy', 'LIKE', "%|" . $this->currentUser->id . "|%");
            }
        }*/

        if (isset($q) && $q != "") {
            $data = $data
                ->where(function ($query) use ($q) {
                    $query
                        ->where('name', 'LIKE', "%$q%")
                        ->orWhere('email', 'LIKE', "%$q%")
                        ->orWhere('phone', 'LIKE', "%$q%");
                });
        }

        if (isset($called_date_range) && $called_date_range != "") {
            $called_date_range_arr = explode(" - ", $called_date_range);
            $from = trim($called_date_range_arr[0]);
            $to = trim($called_date_range_arr[1]);
            $data = $data->whereBetween('created_at', [$from . ' 00:00:00', $to . ' 23:59:59']);
        }


        $order = request()->get('leadid');
        if (isset($order) && $order != "") {
            $order = trim($order);
            if (in_array($order, ['asc', 'desc'])) {
                $data = $data->orderby('id', trim($order));
            } else {
                $data = $data->orderby('id', 'DESC');
            }
        } else {
            $data = $data->orderby('id', 'DESC');
        }

        //echo getRawQueriesInLaravel($data);

        return $data;

    }

    public function updateLeads()
    {
        $call_date = request()->get('call_date');
        $ids = explode(',', request()->get('leads_id'));
        $ids = array_filter($ids);

        if (!empty($ids) && request()->get('lead_action') != "") {
            foreach ($ids as $id) {
                # code...
                $leads = AllLeads::find($id);
                $leads->comments = request()->get('comments');
                if (!empty($call_date)) {
                    $leads->call_date_time = (new \DateTime($call_date))->format('Y-m-d H:i:s');
                }
                $leads->status = request()->get('lead_action');
                $leads->save();
            }
            return array('status' => 'success');
        } else {
            return array('status' => 'failed');
        }
    }

    public function assignLeads(Request $request){
        $ids = $request->get('leads');
        if($ids !="") {
            $leads = explode(",",$ids);
            foreach ($leads as $lead) {
                $leadsdata = AllLeads::where('id',$lead)->get();

                //print_r($leadsdata[0]->id);
                $history = new Lmsassignhistory;
                $history->lead_id = $lead;
                $history->from_assignee = $leadsdata[0]->agent_id;
                $history->to_assignee = $request->get('assignto');
                $history->updated_by = auth()->user()->id;
                $history->insurance_type = 'MIX';
                $history->save();

                $leadsdata[0]->agent_id = $request->get('assignto');
                $leadsdata[0]->save();
            }
        }
        return ['success'=>1];
    }
    public static function createLead($args)
    {
        $lead = new HealthLeads();
        $lead->name = $args['name'];
        $lead->product = $args['product'];
        $lead->email = isset($args['email']) ? $args['email'] : 'unknow@unknown.com';
        $lead->phone = isset($args['mobile']) ? $args['mobile'] : 9999999999;
        $lead->status = 0;
        $lead->utm_source = 'referral';
        $lead->agent_id = $args['agent_id'];
        $lead->hierarchy = $args['hierarchy'];
        $lead->raw_data = json_encode($args);
        $lead->save();
        return $lead;
    }

    public static function createBooking($args)
    {
        //pr($args);
        $operationCheckPolicy = OtherOperation::where('insurer_id', $args['insurer_id'])
            ->where('policy_number', $args['policy_number'])
            ->where('product', $args['product'])->get();

        if ($operationCheckPolicy->count() > 0) {
            $status = 107;
        } else {
            $status = config('app.status_WIP');
        }
        $operation = new OtherOperation;
        $operation->lead_id = $args['lead_id'];
        $operation->name = $args['name'];
        $operation->email = isset($args['email']) ? $args['email'] : 'unknow@unknown.com';
        $operation->mobile = isset($args['mobile']) ? $args['mobile'] : 9999999999;
        $operation->insurer_id = @$args['insurer_id'];
        $operation->tp_premium = @$args['tp_premium'];
        $operation->od_premium = $args['od_premium'];
        $operation->final_premium = $args['final_premium'];
        $operation->policy_type = $args['policy_type'];
        $operation->plan_type = $args['plan_type'];
        $operation->policy_number = $args['policy_number'];
        $operation->policy_booking_date = @$args['policy_booking_date'];
        $operation->policy_doc = "";
        $operation->product = $args['product'];
        $operation->utm_source = @$args['utm_source'];
        $operation->agent_id = $args['agent_id'];
        $operation->hierarchy = $args['hierarchy'];
        $operation->updated_by = $args['agent_id'];
        $operation->status = $status;
        if (@$args['utm_source'] == 'TEP') {
            $operation->booked_by = 33;
        } else {
            $operation->booked_by = $args['agent_id'];
        }

        $operation->policy_start_date = $args['policy_start_date'];
        $operation->comments = "Import";
        $operation->raw_data = json_encode($args);
        $operation->save();
        return $operation;
    }

    public static function createActionHistory($args)
    {
        $actionHistory = new OperationActionHistory;
        $actionHistory->operation_id = $args['operation_id'];
        $actionHistory->from_status = 0;
        $actionHistory->to_status = $args['operation_status'];
        $actionHistory->from_sub_status = 0;
        $actionHistory->to_sub_status = 0;
        $actionHistory->call_dttm = (new \DateTime(date('Y-m-d H:i:s', strtotime('+1 day'))))->format('Y-m-d H:i:s');
        $actionHistory->type = $args['product'];
        $actionHistory->updated_by = $args['agent_id'];
        $actionHistory->save();
    }

    public static function sanitizeData($row)
    {
        $company = self::getCompaniesNameVsId();

        $config = [
            'name' => ['name', 'fullname', 'insured-name', 'customer-name'],
            'email' => ['email', 'emailid', 'email-id'],
            'mobile' => ['phone', 'phone-number', 'phone-no.', 'phone-no', 'mobile-number', 'mobileno', 'mobile'],
            'product' => ['vehicle-type'],
            'utm_source' => ['utm-source', 'source'],
            'agent' => ['agent', 'telecaller', 'booked-by', 'booking-by', 'sp', 'code'],
            'company' => ['insurer', 'company', 'company-name', 'insurer-name'],
            'tp_premium' => ['tp-premium', 'third-party-premium', 'tp', 'net-tp'],
            'od_premium' => ['od-premium', 'basic-premium', 'net-od'],
            'final_premium' => ['premium', 'total-premium', 'gross-premium', 'gross-premimum', 'total-policy-premium','gross-amount'],
            'business_type' => ['booking-type','business_type'],
            'policy_type' => ['policy-type'],
            'policy_number' => ['policy-number', 'policy-no.', 'policy-no', 'covernote-no-policy-no'],
            'policy_booking_date' => ['booking-date', 'policy-booking-date'],
            'policy_start_date' => ['policy-start-date', 'start-date'],
            'issuance_date' => ['issuance-date'],
            'city' => ['city', 'location'],
            'vehicle' => ['vehicle', 'modal'],
            'vehicle_number' => ['veh-no', 'vehicale-no', 'vehicale-no.', 'registration-number'],
            'idv' => ['idv'],
            'cng' => ['cng'],
            'c_ncb' => ['current-ncb', 'ncb'],
            'registration_date' => ['model', 'mfg year', 'year-of-manufacture'],
            'engine_no' => ['engine', 'engine-no', 'engine-No.'],
            'chassis_no' => ['chassis', 'chassis-no', 'chassis-number'],
            'previous_insurer' => ['previous-insurance-co'],
            'zero_dep' => ['nil-deprecation', 'zero-dep'],
            'fuel' => ['fuel'],
            'expire_date' => ['expire_date', 'end-date'],
            'address' => ['address'],
            'pincode' => ['pincode'],
            'state' => ['state'],
            'body_type' => ['body-type'],
            'invoice' => ['invoice'],
            'mode_of_payment' => ['mode-of-payment'],
            'cubic_capacity' => ['cubic-capacity/watts', 'cubic-capacity'],
            'status'=>['status'],
            'plan_type'=>['plan-type'],
            'policy_doc'=>['policy-doc'],
            'plan_name'=>['plan-name'],
            'extra_info_1'=>['extra-info-1'],
            'application_number'=>['application-number'],

        ];

        foreach ($row as $key => $value) {
            $value = trim($value);
            $key = strtolower($key);
            $key = str_replace(" ", "", $key);
            $key = str_replace("_", "-", $key);
            $key = str_replace("/", "-", $key);
            $key = trim($key);
            //$toSave['utm_source'] = '';
            if (in_array($key, $config['name'])) {
                $toSave['name'] = !empty($value) ? $value : 'No Name';
                $toSave['name'] = ucwords($toSave['name']);
            }
            if (in_array($key, $config['email'])) {
                $toSave['email'] = !empty($value) ? $value : 'unknow@unknown.com';
            } else {
                $toSave['email'] = 'unknow@unknown.com';
            }
            if (in_array($key, $config['mobile'])) {
                $toSave['mobile'] = !empty($value) ? $value : '9999999999';
            } else {
                $toSave['mobile'] = '9999999999';
            }
            if (in_array($key, $config['product'])) {
                $product_type = self::getProductType($value);
                $toSave['product'] = !empty($product_type) ? $product_type : '';
            }
            if (in_array($key, $config['utm_source'])) {
                if (!empty($value)) {
                    $toSave['utm_source'] = $value;
                }
            }
            if (in_array($key, $config['agent'])) {
                $agentInfo = self::getAgentId(@$toSave['utm_source'], $value);
                if ($agentInfo['utm_source'] != '') {
                    $toSave['utm_source'] = $agentInfo['utm_source'];
                }
                $toSave['agent_id'] = $agentInfo['agent_code'];
                $toSave['hierarchy'] = $agentInfo['hierarchy'];

            }
            if (in_array($key, $config['company'])) {
                $value = slugify($value);
                if (isset($company[$value]) && $company[$value] != "") {
                    $companyObj = $company[$value];
                } else {
                    foreach ($company as $cid => $cobj) {
                        if (str_contains($cid, $value)) {
                            $companyObj = $cobj;
                            break;
                        }
                    }
                }
                $toSave['insurer_id'] = !empty($companyObj->company_id) ? $companyObj->company_id : '';
            }
            if (in_array($key, $config['tp_premium'])) {
                $toSave['tp_premium'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['od_premium'])) {
                $toSave['od_premium'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['final_premium'])) {
                $toSave['final_premium'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['policy_type'])) {
                $toSave['policy_type'] = !empty($value) ? $value : 'comprehensive';
            } else {
                $toSave['policy_type'] = 'comprehensive';
            }
            if (in_array($key, $config['policy_number'])) {
                $value = str_replace('-',"",$value);
                $toSave['policy_number'] = !empty($value) ? $value : '';

                $month=data('m');
                $year=data('Y');
                $path = 'https://policiesdump.s3-us-west-2.amazonaws.com/'.$year.'/'.$month;
                $value = str_replace(" ","",$value);
                $value = str_replace("/","",$value);
                $path = $path."/".$value;
                $toSave['policy_doc'] = !empty($value) ? $path : '';
            }
            if (in_array($key, $config['policy_start_date'])) {
                if (!empty($value)) {
                    $policy_start_date = date("Y-m-d", strtotime($value));
                    $toSave['policy_start_date'] = $policy_start_date;
                } else {
                    $policy_start_date = date("Y-m") . "-01";
                    $toSave['policy_start_date'] = $policy_start_date;
                }
            }
            if (in_array($key, $config['policy_booking_date'])) {
                if (!empty($value)) {
                    $policy_booking_date = date("Y-m-d", strtotime($value));
                    $toSave['policy_booking_date'] = $policy_booking_date;
                }
            }


            if (in_array($key, $config['vehicle_number'])) {
                $toSave['vehicle_number'] = !empty($value) ? $value : '';
            }

            if (in_array($key, $config['plan_type'])) {
                $value = strtolower($value);
                $value = str_replace(" ","-",$value);
                $toSave['plan_type'] = !empty($value) ? $value : '';
            } else {
                $toSave['plan_type'] = 'rollover';
            }

            if (in_array($key, $config['registration_date'])) {
                $registration_date = "";
                if (strlen($value) == 4) {
                    $registration_date = $value . "-01-01";
                }
                $toSave['registration_date'] = !empty($registration_date) ? $registration_date : '';
                $toSave['manufacturing_date'] = !empty($registration_date) ? $registration_date : '';
            }
            if (in_array($key, $config['idv'])) {
                $toSave['ope_meta']['idv'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['cng'])) {
                $toSave['ope_meta']['cng'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['c_ncb'])) {
                $toSave['ope_meta']['c_ncb'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['engine_no'])) {
                $toSave['ope_meta']['engine_no'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['city'])) {
                $toSave['ope_meta']['city'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['zero_dep'])) {
                $toSave['ope_meta']['zero_dep'] = !empty($value) ? $value : '';
            }

            if (in_array($key, $config['issuance_date'])) {
                $toSave['ope_meta']['issuance_date'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['pincode'])) {
                $toSave['ope_meta']['pincode'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['address'])) {
                $toSave['ope_meta']['address'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['state'])) {
                $toSave['ope_meta']['state'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['issuance_date'])) {
                $toSave['ope_meta']['issuance_date'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['body_type'])) {
                $toSave['ope_meta']['body_type'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['invoice'])) {
                $toSave['ope_meta']['invoice'] = !empty($value) ? $value : '';
            }

            if (in_array($key, $config['expire_date'])) {
                if (!empty($value)) {
                    $expire_date = date("Y-m-d", strtotime($value));
                    $toSave['ope_meta']['expire_date'] = $expire_date;
                }
            }
            if (in_array($key, $config['fuel'])) {
                $toSave['ope_meta']['fuel'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['fuel'])) {
                $toSave['ope_meta']['fuel'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['mode_of_payment'])) {
                $toSave['ope_meta']['mode_of_payment'] = !empty($value) ? $value : '';
            }

            if (in_array($key, $config['plan_name'])) {
                $toSave['ope_meta']['plan_name'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['extra_info_1'])) {
                $toSave['ope_meta']['extra_info_1'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['application_number'])) {
                $toSave['ope_meta']['application_number'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['previous_insurer'])) {
                $value = slugify($value);
                if (isset($company[$value]) && $company[$value] != "") {
                    $companyObj = $company[$value];
                } else {
                    foreach ($company as $cid => $cobj) {
                        if (str_contains($cid, $value)) {
                            $companyObj = $cobj;
                            break;
                        }
                    }
                }
                $toSave['ope_meta']['previous_insurer'] = !empty($companyObj->company_id) ? $companyObj->company_id : '';
            }

        }

        return $toSave;
    }

    public function viewhLeads($id){
        $data = AllLeads::where('id',$id)->get();
        $json_data = json_decode($data[0]['raw_data'],1);
        //echo "<pre>";print_r($json_data);die;
        $unset_arr =['id','_token','_t','product','g-recaptcha-response','agent','fetch_mode','otp_required','user_id'];
        foreach ($json_data as $key=>$value){
            if(in_array($key,$unset_arr)){
                unset($json_data[$key]);
            }
        }
        return view('cms::leads.health-leads-view', compact('data','json_data'));
    }

}
