<?php

namespace App\modules\backend\cms\Controllers;

use App\Helpers\LeadsHelper;
use App\Http\Controllers\Controller;
use App\modules\backend\cms\Models\LmsStatus;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Maatwebsite\Excel\Facades\Excel;
use Carbon\Carbon;
use App\modules\backend\cms\Models\AllLeads;
use App\Helpers\TeamHelper;
use App\modules\backend\cms\Models\Lmsassignhistory;

/**
 * File: OperationsController.php
 * Date: 8/29/2016
 * Time: 5:27 PM
 * Author: Mohammad Arshi
 * Email: Mohammad Arshi
 */
class MotorLeadsController extends Controller
{
    public $utm;
    const CACHE_KEY = 'OtherOperationsController';

    public function __construct()
    {

        $this->middleware('permission:lead_motor');

        $this->product_type = ['other-car' => 'car', 'other-bike' => 'bike', 'cveh' => 'cveh', 'travel' => 'travel', 'others' => 'other', 'other-all' => ''];
    }


    public function getSubStatus()
    {
        $id = request()->get('status_id');
        request()->get('asddas');
        $stlist = '';
        if (!empty($id)) {
            $statuslist = LmsStatus::where('parent_status', $id)->get();
            //echo '<pre>';print_r($statuslist); die;
            if (!empty($statuslist)) {
                foreach ($statuslist as $status) {
                    # code...
                    $stlist .= '<option value="' . $status->status_id . '">' . $status->name . '</option>';
                }
            }


        }
        echo $stlist;
    }

    public function updateLeadOperationStatus()
    {
        checkUserCapablities(['operations_change_status_buttons']);
        if (is_array(request()->get('operation_id'))) {
            foreach (request()->get('operation_id') as $operation_id) {
                $operation = MotorLmsOperation::find($operation_id);
                $operation->{request()->get('status')} = 1;
                $operation->save();
            }
        } else {
            $operation = MotorLmsOperation::find(request()->get('operation_id'));
            $operation->{request()->get('status')} = 1;
            $operation->save();
        }
        return ['status' => 1, 'message' => 'success'];
    }

    public function myLeadStatus()
    {
        $lead_type = !empty(request()->get('lead_type')) ? request()->get('lead_type') : 2;
        if ($lead_type == 2) {
            $module = 'motor_operations_my_leads';
        } elseif ($lead_type == 1) {
            $module = 'motor_operations_all_leads_my_leads';
        }
        checkUserCapablities([$module]);
        $q = request()->get('q');
        $date_range = request()->get('date');
        $date_range1 = request()->get('date_of_payment');
        $date_range2 = request()->get('date_of_issuance');
        $search_status = request()->get('search_status');
        $search_lead_operation_status = request()->get('lead_operation_status');
//        echo $search_lead_operation_status;die;
        $search_sub_status = request()->get('search_sub_status');
        $search_call_date = request()->get('search_call_date');
        $booked_by = request()->get('booked_by');
        $system = request()->get('system');
        $utm_source = request()->get('utm_source');
        $utm_term = request()->get('utm_term');
        $utm_medium = request()->get('utm_medium');
        $utm_campaign = request()->get('utm_campaign');
        $sort = !empty(request()->get('sort')) ? request()->get('sort') : 'created_at';
        $order = !empty(request()->get('order')) ? request()->get('order') : 'desc';
        $filter = Input::all();
        $status = LmsStatus::wherein('status_group', ['lms_operations', 'operation_sub_status', 'lms_operations_dttm'])->get();
        $users = Admin::wherein('role', Config::get('app.motor_lms_operations_role'))->get();
        $u = [];
        $stlist = '<option value="">Select Sub Status</option>';
        if (!empty($search_status)) {
            $statuslist = LmsStatus::where('parent_status', $search_status)->get();
            if (!empty($statuslist)) {
                foreach ($statuslist as $substatus) {
                    if ($substatus->status_id == $search_sub_status) {
                        $stlist .= '<option value="' . $substatus->status_id . '" selected>' . $substatus->name . '</option>';
                    } else {
                        $stlist .= '<option value="' . $substatus->status_id . '">' . $substatus->name . '</option>';
                    }
                }
            }
        }
        foreach ($users as $user) {
            $u[$user->id] = $user->name;
        }
        $s = [];
        foreach ($status as $statu) {
            $s[$statu->status_id] = $statu->name;
        }
//        $users_all=Admin::where(['status'=>'Active'])->get();
        if (Cache::has('teams_of_' . Auth::admin()->user()->id)) {
            $teams = Cache::get('teams_of_' . Auth::admin()->user()->id);
            $termTeams = $this->filterTeamsByTeamTypes($teams, 1);
//        dd($termTeams);
            $users_all = [];
            $users_id = [];
            foreach ($termTeams as $team) {
                $users_all = array_merge($this->getTeamMembers($team['id']), $users_all);
            }
        } else {
            $users_all = Cache::get('users_of_' . Auth::admin()->user()->id);
        }
//dd($users_all);
        foreach ($users as $user) {
            $u[$user['id']] = $user['name'];
        }

        $operations = LmsOperation::select(['motor_lms_operations.*', 'companies.company_name', 'admins.name as booked_by_name']);
        // $operations=LmsOperation::select(['motor_lms_operations.*','companies.company_name']);
        if ($lead_type == 2) {
            $operations = $operations->where(['motor_lms_operations.booked_by' => Auth::admin()->user()->id]);
        } elseif ($lead_type == 1) {
            /*$reportees=Reportees::where('user_id',Auth::admin()->user()->id)->first();
            $show_all_leads=!empty($reportees->show_all_leads)?$reportees->show_all_leads:0;
            if (!empty($reportees->reported_user_id))
                $reportees=explode(',',$reportees->reported_user_id);
            if ($show_all_leads!=1) {*/
            foreach ($users_all as $item) {
                $users_id[] = $item['id'];
            }
//            $users_id[]=Auth::admin()->user()->id;
            if (!empty($users_id)) {
                $operations = $operations->wherein('motor_lms_operations.booked_by', $users_id);
                /*$users_all=Admin::where(['status'=>'Active'])->wherein('id',$reportees)->get();*/
            }
//            }
        }
        if (!empty($q)) {
            $operations = $operations->where(function ($query) use ($q) {
                return $query->where('motor_lms_operations.proposer_name', 'like', '%' . $q . '%')
                    ->orwhere('motor_lms_operations.lead_id', 'like', '%' . $q . '%')
                    ->orwhere('motor_lms_operations.proposer_email', 'like', '%' . $q . '%')
                    ->orwhere('motor_lms_operations.proposer_mobile', 'like', '%' . $q . '%')
                    ->orwhere('motor_lms_operations.proposer_alternate_mobile', 'like', '%' . $q . '%')
                    ->orwhere('motor_lms_operations.insured_name', 'like', '%' . $q . '%')
                    ->orwhere('motor_lms_operations.application_number', 'like', '%' . $q . '%');
            });
        }
        if (!empty($date_range)) {
            $dates = explode(' - ', $date_range);
            $from = $dates[0] . ' 00:00:00';
            $to = $dates[1] . ' 23:59:59';
            $operations = $operations->where('motor_lms_operations.created_at', '>=', $from)->where('motor_lms_operations.created_at', '<=', $to);
        }
        if (!empty($date_range1)) {
            $date = explode(' - ', $date_range1);
            $from = $date[0];
            $to = $date[1];
            $operations = $operations->where('motor_lms_operations.date_of_payment', '>=', $from)->where('motor_lms_operations.date_of_payment', '<=', $to);
        }
        if (!empty($date_range2)) {
            $date = explode(' - ', $date_range2);
            $from = $date[0];
            $to = $date[1];
            $operations = $operations->where('motor_lms_operations.date_of_issuance', '>=', $from)->where('motor_lms_operations.date_of_issuance', '<=', $to);
        }
        if (!empty($search_call_date)) {
            $dates = explode(' - ', $search_call_date);
            $from = $dates[0] . ' 00:00:00';
            $to = $dates[1] . ' 23:59:59';
            $operations = $operations->where('motor_lms_operations.call_dttm', '>=', $from)->where('motor_lms_operations.call_dttm', '<=', $to);
        }
        if (!empty($search_status)) {
            if (is_array($search_status)) {
                array_filter($search_status);
                $operations = $operations->wherein('motor_lms_operations.status', $search_status);
            } else {
                $operations = $operations->where(['motor_lms_operations.status' => $search_status]);
            }
        }
        if (!empty($search_lead_operation_status)) {
            if (is_array($search_lead_operation_status)) {
                foreach ($search_lead_operation_status as $k => $search_lead_operation_statu) {
                    $operations = $operations->where(['motor_lms_operations.' . $k => $search_lead_operation_statu]);
                }
            }
        }
        if (!empty($search_sub_status)) {
            $operations = $operations->where(['motor_lms_operations.sub_status' => $search_sub_status]);
        }
        if (!empty($booked_by)) {
            $operations = $operations->where(['motor_lms_operations.booked_by' => $booked_by]);
        }
        if (!empty($system)) {
            $operations = $operations->where(['motor_lms_operations.system' => $system]);
        }

        $currentUser_utm = "";
        if (!empty($this->currentUser->utm_source)) {
            $currentUser_utm = explode(',', $this->currentUser->utm_source);
        }

        if (!empty($this->role->utm_source)) {
            $currentUser_utm = explode(',', $this->role->utm_source);
        }

        $common_utm_source = array();
        if (!empty($utm_source)) {
            if (isset($currentUser_utm) && is_array($currentUser_utm) && count($currentUser_utm) > 0) {
                $common_utm_source = array_intersect($utm_source, $currentUser_utm);
            }
        }

        if (count($common_utm_source) > 0) {
            $utm_source = $common_utm_source;
        } else if (!empty($currentUser_utm)) {
            $utm_source = $currentUser_utm;
        }

        if (!empty($utm_source)) {
            if (in_array('Empty', $utm_source)) {
                $operations = $operations->where(function ($q) use ($utm_source) {
                    return $q->where('motor_lms_operations.utm_source', '=', '')
                        ->orwhereIn('motor_lms_operations.utm_source', $utm_source);
                });
            } else {
                $operations = $operations->where(function ($q) use ($utm_source) {
                    return $q->whereIn('motor_lms_operations.utm_source', $utm_source);
                });
            }
        }

        if (!empty($utm_term)) {
            $operations = $operations->where(function ($q) use ($utm_term) {
                return $q->where('motor_lms_operations.utm_term', '=', $utm_term);
            });
        }

        if (!empty($utm_medium)) {
            $operations = $operations->where(function ($q) use ($utm_medium) {
                return $q->where('motor_lms_operations.utm_medium', '=', $utm_medium);
            });
        }

        if (!empty($utm_campaign)) {
            $operations = $operations->where(function ($q) use ($utm_campaign) {
                return $q->where('motor_lms_operations.utm_medium', '=', $utm_campaign);
            });
        }


        $operations = $operations->join('companies', 'motor_lms_operations.insurer_id', '=', 'companies.company_id')
            ->join('admins', 'motor_lms_operations.booked_by', '=', 'admins.id')
            ->orderby('motor_lms_operations.' . $sort, $order);
        if (isset($filter['download']) && $filter['download'] == 'yes') {
            $checked = null;
            if (!empty($filter['checked'])) {
                $checked = explode(',', $filter['checked']);
                $operations = $operations->wherein('motor_lms_operations.operation_id', $checked);
            }
            $operations = $operations->get();
            \Excel::create('Operations Lead Status Report - ' . date('Y-m-d H:i:s'), function ($excel) use ($operations, $s) {
                $excel->sheet('Operations Lead Status Sheet', function ($sheet) use ($operations, $s) {
                    $sheet->loadView('cms::operations.table')->with(['operations' => $operations, 'status_array' => $s]);
                });
            })->export('xls');

        }

        $all_users = Admin::select(['id', 'name', 'email'])->get()->toArray();
        $operations = $operations->paginate(10);
        $operations->setPath('lead-status');
        $operations->appends(Input::except('page'));
        return view('cms::operations.my-lead-status')->with(['operations' => $operations, 'status' => $status, 'users' => $users, 'users_all' => $users_all, 'user_array' => $u, 'status_array' => $s, 'sub_status' => $stlist, 'all_users' => $all_users]);
    }

    public function import()
    {
        $file = Input::file('bookingfile');
        $error = [];
        $count = 0;
        $company = self::getCompanies();
        $company = $company->toArray();
        $status = self::getStatus();
        $sub_status = self::getSubStatus();
        if (!empty($file)) {
            $import_storage = $file->move(storage_path() . '/import/', date('Ymd') . '_' . date('His') . '_' . str_random(5) . '_' . $file->getClientOriginalName());
            Excel::load($import_storage, function ($reader) use (&$error, &$count, $company) {
                $reader->each(function ($row) use (&$error, &$count, $company) {
                    $row = $row->toArray();
                    $toSave = self::sanitizeData($row);
                    //pr($toSave);die;
                    if (isset($toSave['product']) && $toSave['product'] != "") {
                        //pr($toSave);die;
                        $lead = self::createLead($toSave);
                        $toSave['lead_id'] = $lead->id;
                        $operation = self::createBooking($toSave);
                        $toSave['operation_id'] = $operation->id;
                        $toSave['operation_status'] = $operation->status;
                        self::createActionHistory($toSave);
                        $count++;
                        //pr($toSave);die;
                    }
                });
            });
        }
        \Session::flash('message', 'Import Successfull! ' . $count . ' Rows Inserted.');
        return Redirect::back()
            ->with('error', $error);
    }

    public function getPreviousInsurers()
    {
        $insurers = [];
        if (Input::has('company_id') && request()->get('company_id') == 63) {
            $insurers = DB::table('raw_kotak_insurers')->select('insurer_name')->orderBy('insurer_name', 'ASC')->get();
        } elseif (Input::has('company_id') && request()->get('company_id') == 37) {
            $insurers = DB::table('raw_hdfc_insurer_list')->select('InsurerName as insurer_name')->where('status', '=', 1)->orderBy('InsurerName', 'ASC')->get();
        }

        return ['status' => 1, 'message' => 'success', 'insurers' => $insurers];
    }

    public function getLeads()
    {
        global $memberTree;
        $selectedId = "";
        $selectedName = "";
        $this->currentUser = auth()->user();
        $leads = $this->getLeadsOthers();
        //print_r($leads);die;
        $lmsStatus = LeadsHelper::lmsStatus();
        $statusArray = [];
        foreach ($lmsStatus as $status_id => $status_name) {
            $statusArray[$status_id] = $status_name->name;
        }
        $canSeeFull = canSeeFullHierarchy($this->currentUser->role_id);
        $teamMember = TeamHelper::getTeamMember($canSeeFull);
        $allUsers = [];
        $u = [];
        foreach ($teamMember as $user_id => $item) {
            $allUsers[$user_id] = $item;
            $u[] = ['label' => $item, 'value' => $user_id];
            if ($user_id == request()->get('uid')) {
                $selectedId = $user_id;
                $selectedName = $item;
            }
        }

        $this->currentLeadType = 1;
        //$this->manageStatusData = ManageStatus::all();

        $leads = $leads->paginate(20);
        $leads->setPath('health-leads');
        //$leads->appends(Input::except('page'));

        /*$hierarchy = 0;
        $agent_id = $this->currentUser->id;
        $hierarchy_option = DB::select(DB::raw("SELECT user_id,hierarchy FROM `team_hierarchy` where user_id =$agent_id  ORDER BY id DESC limit 1"));
        if (count($hierarchy_option) > 0) {
            $hierarchy = $hierarchy_option[0]->hierarchy;
        }*/

        return view('cms::leads.health-leads-listing')->with(['leadslist' => $leads, 'lmsstatus' => $lmsStatus, 'users' => $allUsers, 'activeUsers' => $u, 'current_lead_type' => $this->currentLeadType, 'status_array' => $statusArray, 'manage_status' => $lmsStatus, 'selectedName' => $selectedName, 'selectedId' => $selectedId]);
    }

    public function getLeadsOthers()
    {
        $product = 'motor';
        $called_date_range = request()->get('called_date_range');
        $q = request()->get('q');
        $uid = request()->get('uid');
        $lead_action = request()->get('lead_action');
        $data = new AllLeads;

        if (isset($product) && $product != "") {
            $product_code = $product;
            $data = $data->where('product', '=', $product_code);
        }

        if (isset($lead_action) && $lead_action != "") {
            $data = $data->where('status', '=', $lead_action);
        }

        /*if (canSeeFullHierarchy($this->currentUser->role_id)) {
            if (isset($uid) && $uid != "") {
                $data = $data->where('hierarchy', 'LIKE', "%|$uid|%");
            }
        } else {
            if (isset($uid) && $uid != "") {
                $data = $data->where('hierarchy', 'LIKE', "%|$uid|%");
                $data = $data->where('hierarchy', 'LIKE', "%|" . $this->currentUser->id . "|%");
            } else {
                $data = $data->where('hierarchy', 'LIKE', "%|" . $this->currentUser->id . "|%");
            }
        }*/

        if (isset($q) && $q != "") {
            $data = $data
                ->where(function ($query) use ($q) {
                    $query
                        ->where('name', 'LIKE', "%$q%")
                        ->orWhere('email', 'LIKE', "%$q%")
                        ->orWhere('phone', 'LIKE', "%$q%");
                });
        }

        if (isset($called_date_range) && $called_date_range != "") {
            $called_date_range_arr = explode(" - ", $called_date_range);
            $from = trim($called_date_range_arr[0]);
            $to = trim($called_date_range_arr[1]);
            $data = $data->whereBetween('created_at', [$from . ' 00:00:00', $to . ' 23:59:59']);
        }


        $order = request()->get('leadid');
        if (isset($order) && $order != "") {
            $order = trim($order);
            if (in_array($order, ['asc', 'desc'])) {
                $data = $data->orderby('id', trim($order));
            } else {
                $data = $data->orderby('id', 'DESC');
            }
        } else {
            $data = $data->orderby('id', 'DESC');
        }

        //echo getRawQueriesInLaravel($data);

        return $data;

    }

    public function updateLeads()
    {
        $call_date = request()->get('call_date');
        $ids = explode(',', request()->get('leads_id'));
        $ids = array_filter($ids);

        if (!empty($ids) && request()->get('lead_action') != "") {
            foreach ($ids as $id) {
                # code...
                $leads = AllLeads::find($id);
                $leads->comments = request()->get('comments');
                if (!empty($call_date)) {
                    $leads->call_date_time = (new \DateTime($call_date))->format('Y-m-d H:i:s');
                }
                $leads->status = request()->get('lead_action');
                $leads->save();
            }
            return array('status' => 'success');
        } else {
            return array('status' => 'failed');
        }
    }

    public function assignLeads(Request $request){
        $ids = $request->get('leads');
        if($ids !="") {
            $leads = explode(",",$ids);
            foreach ($leads as $lead) {
                $leadsdata = AllLeads::where('id',$lead)->get();

                //print_r($leadsdata[0]->id);
                $history = new Lmsassignhistory;
                $history->lead_id = $lead;
                $history->from_assignee = $leadsdata[0]->agent_id;
                $history->to_assignee = $request->get('assignto');
                $history->updated_by = auth()->user()->id;
                $history->insurance_type = 'MIX';
                $history->save();

                $leadsdata[0]->agent_id = $request->get('assignto');
                $leadsdata[0]->save();
            }
        }
        return ['success'=>1];
    }
    public static function createLead($args)
    {
        $lead = new HealthLeads();
        $lead->name = $args['name'];
        $lead->product = $args['product'];
        $lead->email = isset($args['email']) ? $args['email'] : 'unknow@unknown.com';
        $lead->phone = isset($args['mobile']) ? $args['mobile'] : 9999999999;
        $lead->status = 0;
        $lead->utm_source = 'referral';
        $lead->agent_id = $args['agent_id'];
        $lead->hierarchy = $args['hierarchy'];
        $lead->raw_data = json_encode($args);
        $lead->save();
        return $lead;
    }

    public static function createBooking($args)
    {
        //pr($args);
        $operationCheckPolicy = OtherOperation::where('insurer_id', $args['insurer_id'])
            ->where('policy_number', $args['policy_number'])
            ->where('product', $args['product'])->get();

        if ($operationCheckPolicy->count() > 0) {
            $status = 107;
        } else {
            $status = config('app.status_WIP');
        }
        $operation = new OtherOperation;
        $operation->lead_id = $args['lead_id'];
        $operation->name = $args['name'];
        $operation->email = isset($args['email']) ? $args['email'] : 'unknow@unknown.com';
        $operation->mobile = isset($args['mobile']) ? $args['mobile'] : 9999999999;
        $operation->insurer_id = @$args['insurer_id'];
        $operation->tp_premium = @$args['tp_premium'];
        $operation->od_premium = $args['od_premium'];
        $operation->final_premium = $args['final_premium'];
        $operation->policy_type = $args['policy_type'];
        $operation->plan_type = $args['plan_type'];
        $operation->policy_number = $args['policy_number'];
        $operation->policy_booking_date = @$args['policy_booking_date'];
        $operation->policy_doc = "";
        $operation->product = $args['product'];
        $operation->utm_source = @$args['utm_source'];
        $operation->agent_id = $args['agent_id'];
        $operation->hierarchy = $args['hierarchy'];
        $operation->updated_by = $args['agent_id'];
        $operation->status = $status;
        if (@$args['utm_source'] == 'TEP') {
            $operation->booked_by = 33;
        } else {
            $operation->booked_by = $args['agent_id'];
        }

        $operation->policy_start_date = $args['policy_start_date'];
        $operation->comments = "Import";
        $operation->raw_data = json_encode($args);
        $operation->save();
        return $operation;
    }

    public static function createActionHistory($args)
    {
        $actionHistory = new OperationActionHistory;
        $actionHistory->operation_id = $args['operation_id'];
        $actionHistory->from_status = 0;
        $actionHistory->to_status = $args['operation_status'];
        $actionHistory->from_sub_status = 0;
        $actionHistory->to_sub_status = 0;
        $actionHistory->call_dttm = (new \DateTime(date('Y-m-d H:i:s', strtotime('+1 day'))))->format('Y-m-d H:i:s');
        $actionHistory->type = $args['product'];
        $actionHistory->updated_by = $args['agent_id'];
        $actionHistory->save();
    }

    public static function sanitizeData($row)
    {
        $company = self::getCompaniesNameVsId();

        $config = [
            'name' => ['name', 'fullname', 'insured-name', 'customer-name'],
            'email' => ['email', 'emailid', 'email-id'],
            'mobile' => ['phone', 'phone-number', 'phone-no.', 'phone-no', 'mobile-number', 'mobileno', 'mobile'],
            'product' => ['vehicle-type'],
            'utm_source' => ['utm-source', 'source'],
            'agent' => ['agent', 'telecaller', 'booked-by', 'booking-by', 'sp', 'code'],
            'company' => ['insurer', 'company', 'company-name', 'insurer-name'],
            'tp_premium' => ['tp-premium', 'third-party-premium', 'tp', 'net-tp'],
            'od_premium' => ['od-premium', 'basic-premium', 'net-od'],
            'final_premium' => ['premium', 'total-premium', 'gross-premium', 'gross-premimum', 'total-policy-premium','gross-amount'],
            'business_type' => ['booking-type','business_type'],
            'policy_type' => ['policy-type'],
            'policy_number' => ['policy-number', 'policy-no.', 'policy-no', 'covernote-no-policy-no'],
            'policy_booking_date' => ['booking-date', 'policy-booking-date'],
            'policy_start_date' => ['policy-start-date', 'start-date'],
            'issuance_date' => ['issuance-date'],
            'city' => ['city', 'location'],
            'vehicle' => ['vehicle', 'modal'],
            'vehicle_number' => ['veh-no', 'vehicale-no', 'vehicale-no.', 'registration-number'],
            'idv' => ['idv'],
            'cng' => ['cng'],
            'c_ncb' => ['current-ncb', 'ncb'],
            'registration_date' => ['model', 'mfg year', 'year-of-manufacture'],
            'engine_no' => ['engine', 'engine-no', 'engine-No.'],
            'chassis_no' => ['chassis', 'chassis-no', 'chassis-number'],
            'previous_insurer' => ['previous-insurance-co'],
            'zero_dep' => ['nil-deprecation', 'zero-dep'],
            'fuel' => ['fuel'],
            'expire_date' => ['expire_date', 'end-date'],
            'address' => ['address'],
            'pincode' => ['pincode'],
            'state' => ['state'],
            'body_type' => ['body-type'],
            'invoice' => ['invoice'],
            'mode_of_payment' => ['mode-of-payment'],
            'cubic_capacity' => ['cubic-capacity/watts', 'cubic-capacity'],
            'status'=>['status'],
            'plan_type'=>['plan-type'],
            'policy_doc'=>['policy-doc'],
            'plan_name'=>['plan-name'],
            'extra_info_1'=>['extra-info-1'],
            'application_number'=>['application-number'],

        ];

        foreach ($row as $key => $value) {
            $value = trim($value);
            $key = strtolower($key);
            $key = str_replace(" ", "", $key);
            $key = str_replace("_", "-", $key);
            $key = str_replace("/", "-", $key);
            $key = trim($key);
            //$toSave['utm_source'] = '';
            if (in_array($key, $config['name'])) {
                $toSave['name'] = !empty($value) ? $value : 'No Name';
                $toSave['name'] = ucwords($toSave['name']);
            }
            if (in_array($key, $config['email'])) {
                $toSave['email'] = !empty($value) ? $value : 'unknow@unknown.com';
            } else {
                $toSave['email'] = 'unknow@unknown.com';
            }
            if (in_array($key, $config['mobile'])) {
                $toSave['mobile'] = !empty($value) ? $value : '9999999999';
            } else {
                $toSave['mobile'] = '9999999999';
            }
            if (in_array($key, $config['product'])) {
                $product_type = self::getProductType($value);
                $toSave['product'] = !empty($product_type) ? $product_type : '';
            }
            if (in_array($key, $config['utm_source'])) {
                if (!empty($value)) {
                    $toSave['utm_source'] = $value;
                }
            }
            if (in_array($key, $config['agent'])) {
                $agentInfo = self::getAgentId(@$toSave['utm_source'], $value);
                if ($agentInfo['utm_source'] != '') {
                    $toSave['utm_source'] = $agentInfo['utm_source'];
                }
                $toSave['agent_id'] = $agentInfo['agent_code'];
                $toSave['hierarchy'] = $agentInfo['hierarchy'];

            }
            if (in_array($key, $config['company'])) {
                $value = slugify($value);
                if (isset($company[$value]) && $company[$value] != "") {
                    $companyObj = $company[$value];
                } else {
                    foreach ($company as $cid => $cobj) {
                        if (str_contains($cid, $value)) {
                            $companyObj = $cobj;
                            break;
                        }
                    }
                }
                $toSave['insurer_id'] = !empty($companyObj->company_id) ? $companyObj->company_id : '';
            }
            if (in_array($key, $config['tp_premium'])) {
                $toSave['tp_premium'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['od_premium'])) {
                $toSave['od_premium'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['final_premium'])) {
                $toSave['final_premium'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['policy_type'])) {
                $toSave['policy_type'] = !empty($value) ? $value : 'comprehensive';
            } else {
                $toSave['policy_type'] = 'comprehensive';
            }
            if (in_array($key, $config['policy_number'])) {
                $value = str_replace('-',"",$value);
                $toSave['policy_number'] = !empty($value) ? $value : '';

                $month=data('m');
                $year=data('Y');
                $path = 'https://policiesdump.s3-us-west-2.amazonaws.com/'.$year.'/'.$month;
                $value = str_replace(" ","",$value);
                $value = str_replace("/","",$value);
                $path = $path."/".$value;
                $toSave['policy_doc'] = !empty($value) ? $path : '';
            }
            if (in_array($key, $config['policy_start_date'])) {
                if (!empty($value)) {
                    $policy_start_date = date("Y-m-d", strtotime($value));
                    $toSave['policy_start_date'] = $policy_start_date;
                } else {
                    $policy_start_date = date("Y-m") . "-01";
                    $toSave['policy_start_date'] = $policy_start_date;
                }
            }
            if (in_array($key, $config['policy_booking_date'])) {
                if (!empty($value)) {
                    $policy_booking_date = date("Y-m-d", strtotime($value));
                    $toSave['policy_booking_date'] = $policy_booking_date;
                }
            }


            if (in_array($key, $config['vehicle_number'])) {
                $toSave['vehicle_number'] = !empty($value) ? $value : '';
            }

            if (in_array($key, $config['plan_type'])) {
                $value = strtolower($value);
                $value = str_replace(" ","-",$value);
                $toSave['plan_type'] = !empty($value) ? $value : '';
            } else {
                $toSave['plan_type'] = 'rollover';
            }

            if (in_array($key, $config['registration_date'])) {
                $registration_date = "";
                if (strlen($value) == 4) {
                    $registration_date = $value . "-01-01";
                }
                $toSave['registration_date'] = !empty($registration_date) ? $registration_date : '';
                $toSave['manufacturing_date'] = !empty($registration_date) ? $registration_date : '';
            }
            if (in_array($key, $config['idv'])) {
                $toSave['ope_meta']['idv'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['cng'])) {
                $toSave['ope_meta']['cng'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['c_ncb'])) {
                $toSave['ope_meta']['c_ncb'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['engine_no'])) {
                $toSave['ope_meta']['engine_no'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['city'])) {
                $toSave['ope_meta']['city'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['zero_dep'])) {
                $toSave['ope_meta']['zero_dep'] = !empty($value) ? $value : '';
            }

            if (in_array($key, $config['issuance_date'])) {
                $toSave['ope_meta']['issuance_date'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['pincode'])) {
                $toSave['ope_meta']['pincode'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['address'])) {
                $toSave['ope_meta']['address'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['state'])) {
                $toSave['ope_meta']['state'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['issuance_date'])) {
                $toSave['ope_meta']['issuance_date'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['body_type'])) {
                $toSave['ope_meta']['body_type'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['invoice'])) {
                $toSave['ope_meta']['invoice'] = !empty($value) ? $value : '';
            }

            if (in_array($key, $config['expire_date'])) {
                if (!empty($value)) {
                    $expire_date = date("Y-m-d", strtotime($value));
                    $toSave['ope_meta']['expire_date'] = $expire_date;
                }
            }
            if (in_array($key, $config['fuel'])) {
                $toSave['ope_meta']['fuel'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['fuel'])) {
                $toSave['ope_meta']['fuel'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['mode_of_payment'])) {
                $toSave['ope_meta']['mode_of_payment'] = !empty($value) ? $value : '';
            }

            if (in_array($key, $config['plan_name'])) {
                $toSave['ope_meta']['plan_name'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['extra_info_1'])) {
                $toSave['ope_meta']['extra_info_1'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['application_number'])) {
                $toSave['ope_meta']['application_number'] = !empty($value) ? $value : '';
            }
            if (in_array($key, $config['previous_insurer'])) {
                $value = slugify($value);
                if (isset($company[$value]) && $company[$value] != "") {
                    $companyObj = $company[$value];
                } else {
                    foreach ($company as $cid => $cobj) {
                        if (str_contains($cid, $value)) {
                            $companyObj = $cobj;
                            break;
                        }
                    }
                }
                $toSave['ope_meta']['previous_insurer'] = !empty($companyObj->company_id) ? $companyObj->company_id : '';
            }

        }

        return $toSave;
    }

    public static function gspAgentHit($agent_id){

        $cachekey = self::CACHE_KEY . 'gspAgentHit#'.$agent_id;
        if (Cache::has($cachekey)) {
            $agent_arr = Cache::get($cachekey);
        } else {
            $agent_arr = json_decode(file_get_contents("http://gosalesplus.com/api/get-agent-id-and-hierarchy?user_id=" . $agent_id));
            $expiresAt = Carbon::now()->addMinutes(24*60*30*2);
            Cache::put($cachekey, $agent_arr, $expiresAt);
        }
        return $agent_arr;
    }

    public static function getAgentId($utm_source, $code)
    {
        $agent_id = self::empcode($code);
        $hierarchy = "";
        $agent_code = "";
        if ($utm_source == 'TEP') {
            $agent_arr = self::gspAgentHit($agent_id);
            if ($agent_arr->status == 1 && $agent_arr->message == "success") {
                $agent_code = $agent_arr->id;
                $hierarchy = $agent_arr->hierarchy;
            }
        } else {
            if (str_contains($code, 'E00') || str_contains($code, 'P00') || str_contains($code, 'A00')) {
                $agent_arr = self::gspAgentHit($agent_id);
                if ($agent_arr->status == 1 && $agent_arr->message == "success") {
                    $agent_code = $agent_arr->id;
                    $hierarchy = $agent_arr->hierarchy;
                    $utm_source = 'TEP';
                }
            } else {
                $user = Admin::Where('emp_code', $code)->orWhere('name', 'like', '%' . $code . '%')->get();
                $hierarchyObj = TeamHierarchy::where('user_id', $user[0]->id)->orderby('id', 'desc')->take(1);
                $agent_code = $user[0]->id;
                if ($hierarchyObj->count() > 0) {
                    $hierarchyArr = $hierarchyObj->get();
                    $hierarchy = @$hierarchyArr[0]['hierarchy'];
                    $utm_source = 'referral';
                }
            }
        }
        return ['agent_code' => $agent_code, 'hierarchy' => $hierarchy, 'utm_source' => $utm_source];

    }

    public static function empcode($code)
    {
        $code = str_replace("E00", "", $code);
        $code = str_replace("P00", "", $code);
        $code = str_replace("A00", "", $code);
        return $code;
    }

    public static function getProductType($value)
    {
        $value = strtolower($value);
        $config = [
            'comerical' => 'cveh',
            'bike' => 'bike',
            'car' => 'car',
            'other' => 'other',
            'motor private' => 'car',
        ];
        $return = isset($config[$value]) ? $config[$value] : "";
        return $return;
    }

    public static function extraFields()
    {
        $company_list = [];

        foreach (self::getCompaniesNameVsId() as $comp) {
            $company_list[$comp['company_id']] = $comp['company_name'];
        }
        $field = [
            'city' => [
                'type' => 'text',
                'label' => 'City'
            ],
            'vehicle' => [
                'type' => 'text',
                'label' => 'Vehicle Variant'
            ],
            'idv' => [
                'type' => 'text',
                'label' => 'Idv'
            ],
            'cng' => [
                'type' => 'text',
                'label' => 'CNG Value'
            ],
            'c_ncb' => [
                'type' => 'text',
                'label' => 'No Claim Bonus(NCB)'
            ],
            'engine_no' => [
                'type' => 'text',
                'label' => 'Engine No.'
            ],
            'chassis_no' => [
                'type' => 'text',
                'label' => 'Chassis No.'
            ],
            'address' => [
                'type' => 'text',
                'label' => 'Address'
            ],
            'pincode' => [
                'type' => 'text',
                'label' => 'Pincode'
            ],
            'state' => [
                'type' => 'text',
                'label' => 'State'
            ],
            'issuance_date' => [
                'type' => 'text',
                'label' => 'Issuance Date'
            ],
            'previous_insurer' => [
                'type' => 'list',
                'label' => 'Previous Insurer Company',
                'source' => $company_list
            ],
            'zero_dep' => [
                'type' => 'list',
                'label' => 'Zero Dep',
                'source' => ['' => 'Select', 'Yes' => "Yes", 'No' => "No"]
            ],
            'fuel' => [
                'type' => 'text',
                'label' => 'Fuel Type'
            ],
            'expire_date' => [
                'type' => 'date',
                'label' => 'Expire Date',
            ],
            'cubic-capacity' => [
                'type' => 'text',
                'label' => 'Cubic capacity/watts',
            ],
            'invoice' => [
                'type' => 'text',
                'label' => 'Invoice',
            ],
            'mode_of_payment' => [
                'type' => 'text',
                'label' => 'Mode of payment',
            ],
            'plan_name'=>[
                'type'=>'text',
                'label'=>'Plan Name'
            ],
            'extra_info_1'=>[
                'type'=>'text',
                'label'=>'Extra Info 1'
            ],
            'application-number'=>[
                'type'=>'text',
                'label'=>'Application Number'
            ]

        ];
        return $field;
    }

    public function viewhLeads($id){
        $data = AllLeads::where('id',$id)->get();
        $json_data = json_decode($data[0]['raw_data'],1);
        //echo "<pre>";print_r($json_data);die;
        $unset_arr =['id','_token','_t','product','g-recaptcha-response','agent','fetch_mode','otp_required','user_id'];
        foreach ($json_data as $key=>$value){
            if(in_array($key,$unset_arr)){
                unset($json_data[$key]);
            }
        }
        return view('cms::leads.health-leads-view', compact('data','json_data'));
    }
    
}