<?php
namespace App\modules\backend\cms\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Cache;
use App\modules\backend\cms\Models\TeamManagement;
use App\modules\backend\cms\Models\TeamType;
use App\Models\User;
/*use App\modules\backend\cms\Models\TeamUsersMovementHistory;
use App\modules\backend\cms\Models\TeamMovementHistory;

use App\modules\backend\rbac\Models\Admin;
use App\modules\backend\cms\Models\TeamHierarchy;
use App\modules\backend\cms\Controllers\TeamTrait;
*/
/**
 * File: TeamManagementController.php
 * Date: 20/3/17
 * Author: Sainesh Mamgain
 * Email: sainesh.mamgain@comparepolicy.com
 *
 */
class TeamManagementController extends Controller
{

    public function __construct()
    {

    }

    public function printTeams(){
        User::fixTree();
        $nodes = User::whereIn('role_id',config('app.callers'))->get()->toTree();
        return view('cms::team-management.structure')->with(['nodes' => $nodes]);
    }

    public function index()
    {
        $teams = TeamManagement::with('parents')->get()->toArray();
        return view('cms::team-management.index')->with(['teams' => $teams]);
    }

    public function create()
    {
        $parents = TeamManagement::all();
        $allTeamLeads = [];
        foreach ($parents as $parent) {
            $allTeamLeads[] = $parent->team_lead;
        }
        $teamTypes = TeamType::all();
        $users = User::where(['status' => 1])->get();
        $teamLeads = [];
        foreach ($users as $user) {
            if (in_array($user->role_id, config('app.team_lead'))) {
                $teamLeads[] = $user;
            }
        }
        return view('cms::team-management.create')->with(['parents' => $parents, 'teamTypes' => $teamTypes, 'teamLeads' => $teamLeads, 'users' => $users, 'allTeamLeads' => $allTeamLeads]);
    }

    public function store(Request $request)
    {
        $rules = [
            'team_lead' => 'required|unique:team_management',
            'team_name' => 'required|unique:team_management',
            'status' => 'required|in:active,inactive'
        ];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return Redirect::to(url('/users/team-management/create'))
                ->withErrors($validator)
                ->withInput($request->all());
        }
        $team = new TeamManagement();
        $team->parent_id = !empty($request->get('parent_id')) ? $request->get('parent_id') : NULL;
        $team->team_name = $request->get('team_name');
        $team->team_lead = $request->get('team_lead');
        $team->status = $request->get('status');
        $team->save();
        $team->teamTypes()->attach($request->get('teamTypes'));
        $members = $request->get('members');
        if (!empty($members)) {
            foreach ($members as $member) {
                $user = Admin::find($member);
                $user->parent_id = $team->team_lead;
                $user->save();
            }

        }
        Session::flash('message', 'Successfully created Team!');
        return Redirect::to(url('/users/team-management/'));
    }

    public function edit($id)
    {
        $parents = TeamManagement::all();
        $team = TeamManagement::find($id);
        $teamTypes = TeamType::all();
        return view('cms::team-management.edit')->with(['parents' => $parents, 'team' => $team, 'teamTypes' => $teamTypes]);
    }

    public function update($id)
    {
        $rules = [
            'team_name' => 'required|unique:team_management,team_name,' . $id,
//            'status'=>'required|in:active,inactive'
        ];

        $validator = Validator::make(Input::all(), $rules);

        if ($validator->fails()) {
            return Redirect::to(Url::to('/administrator/team-management/' . $id . '/edit'))
                ->withErrors($validator)
                ->withInput(Input::all());
        } else {

            $team = TeamManagement::find($id);
            if (Input::get('manage') && Input::get('manage') == '1') {
//                    $team->parent_id=!empty(Input::get('parent_id'))?Input::get('parent_id'):NULL;
                $team->team_name = Input::get('team_name');
                $team->team_lead = Input::get('team_lead');
//                    $team->status=Input::get('status');
            } else {
                $team->parent_id = !empty(Input::get('parent_id')) ? Input::get('parent_id') : NULL;
                $team->team_name = Input::get('team_name');
                $team->status = Input::get('status');
            }
            $team->save();
            $team->teamTypes()->sync(Input::get('teamTypes'));


        }
        Session::flash('message', 'Successfully edited Team!');
        if (Input::get('manage') && Input::get('manage') == '1') {
            return Redirect::to(getCurrentUrlPrefix() . '/manage');
        }
        return Redirect::to(getCurrentUrlPrefix());
    }

    public function show($id)
    {
        $team = TeamManagement::find($id);
        return view('cms::team-management.show')->with(['team' => $team]);
    }

    public function manage()
    {

        $filterTeamId = base64_decode(Input::get('team'));
        $filterUserId = base64_decode(Input::get('uid'));
        $usersSearch = Admin::where(['status' => 'Active'])->whereIn('role', [37, 38])->get();

        $teams = TeamManagement::whereNull('parent_id')->where('status', '=', 'active')->get();

        $allTeams = TeamManagement::where('status', '=', 'active')->get();
        // dd($allTeams);
        // pr($allTeams); die;
        $allTeamLeads = [];
        foreach ($allTeams as $parent) {
            $allTeamLeads[] = $parent->team_lead;
        }
        // pr($allTeamLeads); die;
        $users = Admin::where(['status' => 'Active'])->get();

        //dd($usersSearch);die;
        $teamTypes = TeamType::all();
        try {
            return view('cms::team-management.team-management')->with(['teams' => $teams, 'users' => $users, 'allTeams' => $allTeams, 'allTeamLeads' => $allTeamLeads, 'teamTypes' => $teamTypes, 'usersSearch' => $usersSearch]);
        } catch (\Throwable $ex) {
            echo $ex->getMessage();
        }
    }

    public function getTeamChild($team_id)
    {
        $team = TeamManagement::find($team_id);
        $childs = $team->children()->where('status', '=', 'active')->get();
        //$members=$team->members;
        $members = $team->members()->where('status', '=', 'Active')->get();
        $childArray = [];
        $teamType = [];
        if ($childs->count() > 0) {
            foreach ($childs as $child) {
                $types = $child->teamTypes()->get();
                if ($types->count() > 0)
                    foreach ($types->toArray() as $item) {
                        $teamType[$child->id][] = $item['team_type'];
                    }
            }
            $childArray = $childs->toArray();
            foreach ($childArray as $key => $item) {
                if (!empty($teamType[$item['id']]))
                    $childArray[$key]['team_type'] = $teamType[$item['id']];
            }
            if (empty($childArray))
                $childArray = [];
        }
        if ($childs->count() > 0 || $members->count() > 0) {
            if ($childs->count() > 0 && $members->count() > 0) {
                return ['status' => '1', 'message' => 'success', 'child' => $childArray, 'members' => $members->toArray(), 'parent_id' => $team_id];
            } elseif ($members->count() > 0 && $childs->count() <= 0)
                return ['status' => '1', 'message' => 'success', 'child' => $childArray, 'members' => $members->toArray(), 'parent_id' => $team_id];
            else
                return ['status' => '1', 'message' => 'success', 'child' => $childArray, 'members' => [], 'parent_id' => $team_id];
        }
        return ['status' => '0', 'message' => 'No Child found.'];
    }

    public function addChildTeams()
    {
        $data = Input::all();
        $parent = TeamManagement::find($data['parent_id']);
        foreach ($data['teams'] as $team) {
            $child = TeamManagement::find($team);
            $parent->children()->save($child);
            $this->moveTeamHistory($team, $data['parent_id'], null);
        }
        return ['status' => '1', 'message' => 'Teams Added successfully!'];
    }


    public function addMembers()
    {
        $data = Input::all();

        $parent = TeamManagement::find($data['parent_team_id']);

        //$users=Admin::find($data['user_id']);
        // dd($users);
        foreach ($data['users'] as $user) {
            $member = Admin::find($user);
            $parent->members()->save($member);
            $this->moveTeamUserHistory($user, $data['parent_team_id'], null);
        }
        return ['status' => '1', 'message' => 'Users Added successfully!'];
    }


    public function moveMember()
    {
        $data = Input::all();
        $user = Admin::find($data['user_id']);
        $current_team = $user->team_id;
        if (empty($current_team))
            $current_team = null;
        $user->team_id = $data['team'];

        $user->save();

        $this->moveTeamUserHistory($data['user_id'], $data['team'], $current_team);
        return ['status' => '1', 'message' => 'Users Moved Successfully!'];
        //  pr($user);die;
    }


    public function removeUser()
    {
        $data = Input::all();
        $user = Admin::find($data['user']);
        $from_team = $user->team_id;
        if (empty($from_team))
            $from_team = null;
        $user->team_id = null;
        $user->save();
        $to_team = null;
        $this->moveTeamUserHistory($data['user'], $to_team, $from_team);
        return ['status' => '1', 'message' => 'User Removed Successfully!'];
    }

    public function moveTeam()
    {
        $data = Input::all();
        $team = TeamManagement::find($data['team_id']);
        $current_team = $team->parent_id;
        if (empty($current_team))
            $current_team = null;
        $team->parent_id = $data['team'];
        $team->save();
        $this->moveTeamHistory($data['team_id'], $data['team'], $current_team);
        return ['status' => '1', 'message' => 'Team Moved Successfully!'];
    }

    public function removeTeam()
    {
        $data = Input::all();
        $team = TeamManagement::find($data['team_id']);
        if ($team->members->count() > 0) {
            foreach ($team->members as $item) {
                $user = Admin::find($item->id);
                $user->team_id = null;
                $user->save();
            }
        }
        if ($team->children->count() > 0) {
            foreach ($team->children as $child) {
                $childTeam = TeamManagement::find($child->id);
                $childTeam->parent_id = null;
                $childTeam->save();
            }
        }
        $team->delete();
        $to_team = null;
        $from_team = $team->parent_id;
        if (empty($from_team))
            $from_team = null;
        $this->moveTeamHistory($data['team_id'], $to_team, $from_team);
        return ['status' => '1', 'message' => 'Team Deleted Successfully!'];
    }


    public function showTeamStructure($userid)
    {

        $usersData = Admin::find($userid);//tc=38 and tl=37

        $team_id = 0;
        if ($usersData->role == config('app.tc')) {
            $team_id = $usersData->team_id;
        } elseif ($usersData->role == config('app.tl')) {
            $team_id = $this->hasTeam($userid);
        } else {
            echo "User is not Team Lead and Telecaller";
        }

        $parentArray = [];
        if ($usersData->role == config('app.tc')) {
            $parentArray[] = $team_id;

        }
        $check = $this->__showTeamStructure($team_id);

        $mainArr = [];

        foreach ($check as $value) {
            //print_r($value);3Array ( [0] => 1 [1] => 9 )
            if (!(is_array($value))) {
                array_push($mainArr, $value);
            } else {
                foreach ($value as $v) {
                    array_push($mainArr, $v);
                }
            }
        }


        $result = array_merge($parentArray, $mainArr);


//print_r($result);
        foreach ($result as $val) {
            $arr = [];
            $teamFinal = TeamManagement::find($val);
            array_push($arr, $teamFinal->team_name);
//    pr("      "."↓");
//    pr($arr[0]);
            print_r("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  " . "↓" . "<br>");
            print_r($arr[0] . "<br>");


        }


    }


    private function __showTeamStructure($id)
    {
//dd($id);
        $team = TeamManagement::find($id);
        $parent[] = $team->parent_id;
        if ($team->parent_id != 1) {
            $parent[] = $this->__showTeamStructure($team->parent_id);
        }
        return $parent;
    }

    public function createHierarchy()
    {

        $no_child_team = Admin::where('status', 'Active')->whereIn('role', [37, 38])->get();
        foreach ($no_child_team as $c) {
            $hierarchy = "|" . $c->id;
            $team_id = (int)$c->team_id;
            if ($team_id != 0) {
                $team = TeamManagement::where('id', $c->team_id)->get();
                if (isset($team) && $team->count() > 0) {
                    $hierarchy .= "|" . $team[0]['team_lead'];
                    $parent_id = (int)$team[0]['parent_id'];
                    if ($parent_id != 0) {
                        $hierarchy = $this->getParent($team[0]['parent_id'], $hierarchy);
                    }
                }
            } else {
                $team = TeamManagement::where('team_lead', $c->id)->get();
                if (isset($team) && $team->count() > 0) {
                    $parent_id = (int)$team[0]['parent_id'];
                    if ($parent_id != 0) {
                        $hierarchy = $this->getParent($team[0]['parent_id'], $hierarchy);
                    }
                }
            }
            $cache_key = 'massgetHierarchy##' . $c->id;
            Cache::forget($cache_key);
            $TeamHierarchy = new TeamHierarchy();
            $TeamHierarchy->user_id = $c->id;
            $TeamHierarchy->hierarchy = $hierarchy . "|";
            $TeamHierarchy->save();

        }
        return Redirect::to('/administrator/team-management/manage');

    }

    public function getParent($parent_id, $hierarchy)
    {

        $team = TeamManagement::where('id', $parent_id)->get();
        if (isset($team) && $team->count() > 0) {
            $hierarchy .= "|" . $team[0]['team_lead'];
            $parent_id = (int)$team[0]['parent_id'];
            if ($parent_id != 0) {
                $hierarchy = $this->getParent($team[0]['parent_id'], $hierarchy);
            }
        }

        return $hierarchy;
    }

}