<?php

namespace App\modules\backend\cms\Controllers;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\modules\backend\cms\Models\AllLeads;
use App\modules\backend\cms\Models\Companies;
use App\modules\backend\cms\Models\LmsStatus;
use App\modules\backend\cms\Models\HealthLmsOperation;
use App\modules\backend\cms\Models\TeamManagement;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Facades\Excel;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use App\Helpers\TeamHelper;
/**
 * File: OperationsController.php
 * Date: 8/29/2016
 * Time: 5:27 PM
 * Author: Sainesh Mamgain
 * Email: saineshmamgain@gmail.com
 */
class healthOperationsController extends Controller
{

    public $utm;
    const CACHE_KEY = 'OtherOperationsController';

    public function __construct()
    {
        $this->middleware('permission:bookings');
    }

    public static function getStatus()
    {
        $all = [];
        $cachekey = self::CACHE_KEY . 'getStatus13';
        if (Cache::has($cachekey)) {
            $all = Cache::get($cachekey);
        } else {
            $status = LmsStatus::wherein('status_group', ['lms_operations', 'operation_sub_status', 'lms_operations_dttm'])->orderby('name','ASC')->get();
            foreach ($status as $statu) {
                $s[$statu->status_id] = $statu->name;
            }
            $all['s'] = $s;
            $all['status'] = $status;
            $expiresAt = Carbon::now()->addMinutes(100000);
            Cache::put($cachekey, $all, $expiresAt);
        }
        return $all;
    }

    public function lmsStatus()
    {
        $cache_key = self::CACHE_KEY . 'lmsStatus';
        if (Cache::has($cache_key)) {
            $statusArray = Cache::get($cache_key);
        } else {
            $lmsStatus = LmsStatus::orderby('name', 'ASC')->get();
            $statusArray = [];
            foreach ($lmsStatus as $status) {
                $statusArray[$status->status_id] = $status;
            }
            $expiresAt = Carbon::now()->addMinutes(1440);
            Cache::put($cache_key, $statusArray, $expiresAt);
        }
        return $statusArray;
    }

    public static function getUser()
    {
        $all = [];
        $u = [];
        $cachekey = self::CACHE_KEY . 'getUser2';
        if (Cache::has($cachekey)) {
            $all = Cache::get($cachekey);
        } else {
            $users = User::wherein('role_id', Config::get('app.lms_operations_role'))->where(['status' => 'Active'])->get();
            foreach ($users as $user) {
                $u[$user->id] = $user->name;
            }
            $all['users'] = $users;
            $all['u'] = $u;
            $expiresAt = Carbon::now()->addMinutes(100);
            Cache::put($cachekey, $all, $expiresAt);
        }
        return $all;
    }

    public static function getCompanies()
    {
        $cachekey = self::CACHE_KEY . 'getCompanies2';
        if (Cache::has($cachekey)) {
            $companies = Cache::get($cachekey);
        } else {
            $companies = Companies::select(['company_id', 'company_name'])
                ->where(['status' => 'Active'])
                ->where(['insurance_type' => 2])
                ->get();
            $expiresAt = Carbon::now()->addMinutes(10000);
            Cache::put($cachekey, $companies, $expiresAt);
        }
        return $companies;
    }

    public static function getCompaniesNameVsId($id = "")
    {
        //echo "===".$id."===";
        $companies = self::getCompanies();
        $cachekey = self::CACHE_KEY . 'getCompaniesNameVsId2';
        if (Cache::has($cachekey)) {
            $arr = Cache::get($cachekey);
        } else {
            $arr = [];
            foreach ($companies as $id => $company) {
                $key = slugify($company->company_name);
                $arr[$key] = $company;
            }
            $expiresAt = Carbon::now()->addMinutes(10000);
            Cache::put($cachekey, $arr, $expiresAt);
        }

        if (isset($id) && $id != "") {
            return $arr[$id];
        }
        return $arr;
    }

    public function index(Request $request)
    {
        $this->middleware('permission:booking_health');
        $this->currentUser = auth()->user();
        $all_status = self::getStatus();
        $s = $all_status['s'];
        $status = $all_status['status'];
        $all_users_data = self::getUser();
        $u = $all_users_data['u'];
        $users = $all_users_data['users'];
        $companies = self::getCompanies();
        $teams = [];
        $canSeeFull = canSeeFullHierarchy($this->currentUser->role_id);
        $teamMember = TeamHelper::getTeamMember($canSeeFull);
        $allUsers = [];
        $u = [];
        foreach ($teamMember as $user_id => $item) {
            $allUsers[$user_id] = $item;
            $u[] = ['label' => $item, 'value' => $user_id];
        }

        $uid = $request->get('uid');
        $selectedName = "===";
        $selectedId = '';
        if(isset($uid) && $uid !=""){
            $selectedName = $allUsers[$uid];
            $selectedId = $uid;
        }
        //echo "<pre>";print_r($allUsers); echo "</pre>";
        $operations = $this->indexQuery($request);
        //echo getRawQueriesInLaravel($operations);
        $operations = $operations->paginate(10);
        $operations->setPath(route('operations.health'));
        $operations->appends($request->except('page'));
        return view('cms::operations.health.index')->with(['operations' => $operations, 'users_all' => $allUsers, 'users' => $users, 'user_array' => $u, 'status_array' => $s, 'status' => $status,'lmsstatus'=>$status, 'companies' => $companies, 'teams' => $teams, 'all_users' => $u, 'all_users_array' => $u,'selectedName' => $selectedName, 'selectedId' => $selectedId]);
    }

    private function indexQuery($request)
    {
        $q = $request->get('q');
        $date_range1 = $request->get('called_date_range');
        $search_status = $request->get('search_status');
        $booked_by = $request->get('uid');
        $utm_source = $request->get('utm_source');
        $insurer_id = $request->get('insurer_id');

        $sort = !empty($request->get('sort')) ? $request->get('sort') : 'created_at';
        $order = !empty($request->get('order')) ? $request->get('order') : 'desc';

        $operations = HealthLmsOperation::select(['health_lms_operations.*']);
        if (!empty($q)) {
            $operations = $operations->where(function ($query) use ($q) {
                return $query->where('health_lms_operations.proposer_name', 'like', '%' . $q . '%')
                    ->orwhere('health_lms_operations.lead_id', 'like', '%' . $q . '%')
                    ->orwhere('health_lms_operations.proposer_email', 'like', '%' . $q . '%')
                    ->orwhere('health_lms_operations.proposer_mobile', 'like', '%' . $q . '%')
                    ->orwhere('health_lms_operations.policy_number', 'like', '%' . $q . '%')
                    ->orwhere('health_lms_operations.operation_id', 'like', '%' . $q . '%');
            });
        }
        if (!empty($date_range1)) {
            $date = explode(' - ', $date_range1);
            $from = $date[0];
            $to = $date[1];
            $operations = $operations->where('health_lms_operations.date_of_payment', '>=', $from)->where('health_lms_operations.date_of_payment', '<=', $to);
        }

        if (!empty($search_status)) {
            $operations = $operations->where(['health_lms_operations.status' => $search_status]);
        }

        if (!empty($booked_by)) {
            $operations = $operations->where(['health_lms_operations.agent_id' => $booked_by]);
        } else {
            if (in_array($this->currentUser->role,config('app.caller_roles'))) {
                $operations = $operations->where('health_lms_operations.hierarchy', 'like', '%|' . $this->currentUser->id . '|%');
            }
        }

        if (!empty($utm_source)) {
            $operations = $operations->where('health_lms_operations.utm_source', $utm_source);
        }
        $operations = $operations
            ->orderby('health_lms_operations.' . $sort, $order);

        return $operations;
    }

    public function addBooking($id)
    {
        $companies = self::getCompanies();
        $status = LmsStatus::where(['status_group' => 'lms'])->get();
        $operation = new \stdClass();
        $lead = new \stdClass();
        if ($id) {
            $lead = AllLeads::find($id);
        } else {
        }
        $product = "health";
        $this->currentUser = auth()->user();
        $canSeeFull = canSeeFullHierarchy($this->currentUser->role_id);
        $teamMember = TeamHelper::getTeamMember($canSeeFull);
        $users = [];
        foreach ($teamMember as $user_id => $item) {
            $users[] = $user_id;
        }
        $childLead = $lead->leadHistory()->orderBy('created_at', 'ASC')->first();

        if(isset($childLead->raw_data)){
          $childLeadRawData = json_decode($childLead->raw_data);
        }else{
            $childLeadRawData = json_decode($lead->raw_data);
        }
        /*echo "<pre>";
        print_r($childLeadRawData);
        echo "</pre>";*/
        return view('cms::operations.health.edit')->with(['companies' => $companies, 'operation' => $operation, 'lead_id' => $id, 'status' => $status, 'users' => $users, 'lead' => $lead, 'product' => $product,'childLeadRawData'=>$childLeadRawData]);
    }

    public function editBooking($id)
    {
        $companies = self::getCompanies();
        $status = LmsStatus::where(['status_group' => 'lms'])->get();
        $operation = new \stdClass();
        if ($id) {
            $operation = HealthLmsOperation::find($id);
        }

        $this->currentUser = auth()->user();
        $canSeeFull = canSeeFullHierarchy($this->currentUser->role_id);
        $teamMember = TeamHelper::getTeamMember($canSeeFull);
        $users = [];
        foreach ($teamMember as $user_id => $item) {
            $users[] = $user_id;
        }

        return view('cms::operations.health.edit2')->with(['companies' => $companies, 'operation' => $operation, 'status' => $status, 'users' => $users]);
    }

    public function viewBooking($id){
        $data = HealthLmsOperation::find($id)->toArray();
        $companies = self::getCompanies();
        foreach($companies as $company){
            if($company->company_id==$data['insurer_id']){
                $data['company'] = $company->company_name;
                break;
            }
        }
        $lmsStatus = self::getStatus();
        $assignee = User::find($data['assignee']);

        $bookedBy = User::find($data['booked_by']);

        $agent = User::find($data['agent_id']);

        $exclude = ['operation_id','lead_id','plan_id','plan_name','insured_name','dob','gender','adults','children','call_dttm','medical_done','document_done','confirmed_by_insurer','created_at','updated_at','date_of_issuance','relation_with_proposer','utm_term','lapsed_date','hierarchy','insured_city','insured_address','insurer_id','assignee','op_comment'];
        $op_history = $data['op_comment'];
        foreach ($data as $key=>$value){

            if($key=='assignee' && isset($assignee)){
                $data['assigned_to'] = $assignee->first_name." ".$assignee->last_name;
            }

            if($key=='booked_by' && isset($bookedBy)){
                $data['booked_by'] = $bookedBy->first_name." ".$bookedBy->last_name;
            }

            if($key=='agent_id' && isset($agent)){
                $data['agent_id'] = $agent->first_name." ".$agent->last_name;
            }

            if($key=='status'){
                $data['status'] = $lmsStatus['s'][$value];
            }

            if($key=='sub_status'){
                $data['sub_status'] = $lmsStatus['s'][$value];
            }

            if(in_array($key,$exclude)){
                unset($data[$key]);
            }
        }
        return view('cms::operations.health.view')->with(['data'=>$data,'op_history'=>$op_history,'lmsStatus'=>$lmsStatus['s']]);
    }

    public function saveBooking($lead_id,Request $request)
    {
        //$lead_id = $request->get('lead_id');
        $rules = [
            'insurer_id' => 'required|numeric',
            'policy_type' => 'required|in:Regular,Limited,Single',
            'application_number' => 'required|unique:health_lms_operations',
            'equote_number' => 'unique:health_lms_operations|different:application_number',
            'policy_number' => 'unique:health_lms_operations|different:application_number',
            'remarks' => 'required',
            'policy_term' => 'required|numeric|max:99',
            'sum_insured' => 'required|numeric|max:500000000',
            'premium' => 'required|numeric|max:5000000',
            'paying_mode' => 'required|regex:/^[a-zA-Z\s-]+$/|max:25|min:3',
            'annual_income' => 'required|in:Less than 3 Lacs,3 Lacs to 5 Lacs,5 Lacs to 10 Lacs,10 Lacs and above',
            'date_of_payment' => 'required|date',
            'proposer_name' => 'required|regex:/^[a-zA-Z\s-]+$/|max:25|min:3',
            'proposer_email' => 'required|email',
            'proposer_city' => 'required|regex:/^[a-zA-Z\s]+$/|max:25|min:3',
            'proposer_address' => 'required',
            'proposer_mobile' => 'required|numeric|digits_between:10,10',
            'proposer_alternate_mobile' => 'numeric|digits_between:10,10',
        ];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return Redirect::to(url('/operations/health/add/'.$lead_id))
                ->withErrors($validator)->withInput($request->all());
        } else {
            $lead = AllLeads::find($lead_id);
            $operation = new HealthLmsOperation();
            $operation->lead_id = $lead_id;
            $operation->insurer_id = $request->get('insurer_id');
            $operation->policy_type = $request->get('policy_type');
            $operation->application_number = $request->get('application_number');
            $operation->equote_number = $request->get('equote_number');
            $operation->policy_number = $request->get('policy_number');
            $operation->policy_term = $request->get('policy_term');
            $operation->sum_insured = $request->get('sum_insured');
            $operation->premium = $request->get('premium');
            $operation->paying_mode = $request->get('paying_mode');
            $operation->annual_income = $request->get('annual_income');
            $operation->date_of_payment = date("Y-m-d",strtotime($request->get('date_of_payment')));
            $operation->remarks = $request->get('remarks');
            $operation->proposer_name = $request->get('proposer_name');
            $operation->proposer_email = $request->get('proposer_email');
            $operation->proposer_city = $request->get('proposer_city');
            $operation->proposer_address = $request->get('proposer_address');
            $operation->proposer_mobile = $request->get('proposer_mobile');
            $operation->proposer_alternate_mobile = $request->get('proposer_alternate_mobile');
            $operation->portability = $request->get('portability');
            $operation->stp_nstp = $request->get('stp_nstp');
            $operation->policy_mode = $request->get('policy_mode');
            $operation->utm_source = $request->get('utm_source');
            $operation->utm_medium = $request->get('utm_medium');
            $operation->utm_term = NULL;
            $operation->utm_campaign = $request->get('utm_campaign');

            $operation->status = Config::get('app.status_WIP');
            $operation->sub_status = Config::get('app.status_WelcomeCallPending');

            $operation->assignee = config('app.operation_supervisor');
            $operation->booked_by = auth()->user()->id;
            $operation->hierarchy = $lead->hierarchy;
            $operation->agent_id = $lead->agent_id;

            $operation->entry_date = date("Y-m-d");
            $operation->call_dttm = (new \DateTime(date('Y-m-d H:i:s', strtotime('+1 day'))))->format('Y-m-d H:i:s');

            $operation->save();

            $lead->status = Config::get('app.lms_lead_booked_status');
            $lead->call_date_time = null;
            $lead->save();

            Session::flash('message', 'Successfully Created Booking!');
            return Redirect::to(url('/operations/health/edit/'.$operation->operation_id));
        }


    }

    public function updateBooking($operation_id,Request $request)
    {
        //$lead_id = $request->get('lead_id');
        $rules = [
            'insurer_id' => 'required|numeric',
            'policy_type' => 'required|in:Regular,Limited,Single',
            'application_number' => 'required|unique:health_lms_operations,application_number,' . $operation_id . ',operation_id',
            'equote_number' => 'unique:health_lms_operations,equote_number,' . $operation_id . ',operation_id|different:application_number',
            'remarks' => 'required',
            'policy_term' => 'required|numeric|max:99',
            'sum_insured' => 'required|numeric|max:500000000',
            'premium' => 'required|numeric|max:5000000',
            'paying_mode' => 'required|regex:/^[a-zA-Z\s-]+$/|max:25|min:3',
            'annual_income' => 'required|in:Less than 3 Lacs,3 Lacs to 5 Lacs,5 Lacs to 10 Lacs,10 Lacs and above',
            'date_of_payment' => 'required|date',
            'proposer_name' => 'required|regex:/^[a-zA-Z\s-]+$/|max:25|min:3',
            'proposer_email' => 'required|email',
            'proposer_city' => 'required|regex:/^[a-zA-Z\s]+$/|max:25|min:3',
            'proposer_address' => 'required',
            'proposer_mobile' => 'required|numeric|digits_between:10,10',
            'proposer_alternate_mobile' => 'numeric|digits_between:10,10',
        ];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return Redirect::to(url('/operations/health/edit/'.$operation_id))
                ->withErrors($validator)->withInput($request->all());
        } else {
            //$supervisor = Admin::find(config('app.operation_supervisor'));
            $operation = HealthLmsOperation::find($operation_id);
            $operation->insurer_id = $request->get('insurer_id');
            $operation->policy_type = $request->get('policy_type');
            $operation->application_number = $request->get('application_number');
            $operation->equote_number = $request->get('equote_number');
            $operation->policy_term = $request->get('policy_term');
            $operation->sum_insured = $request->get('sum_insured');
            $operation->premium = $request->get('premium');
            $operation->paying_mode = $request->get('paying_mode');
            $operation->annual_income = $request->get('annual_income');
            $operation->date_of_payment = date("Y-m-d",strtotime($request->get('date_of_payment')));
            $operation->remarks = $request->get('remarks');
            $operation->proposer_name = $request->get('proposer_name');
            $operation->proposer_email = $request->get('proposer_email');
            $operation->proposer_city = $request->get('proposer_city');
            $operation->proposer_address = $request->get('proposer_address');
            $operation->proposer_mobile = $request->get('proposer_mobile');
            $operation->proposer_alternate_mobile = $request->get('proposer_alternate_mobile');
            $operation->portability = $request->get('portability');
            $operation->stp_nstp = $request->get('stp_nstp');
            $operation->policy_mode = $request->get('policy_mode');
            $operation->utm_source = $request->get('utm_source');
            $operation->utm_medium = $request->get('utm_medium');
            $operation->utm_campaign = $request->get('utm_campaign');
            $operation->save();
            Session::flash('message', 'Successfully Updated Booking!');
            return Redirect::to(url('/operations/health/edit/'.$operation_id));
        }
    }

    public function planlist()
    {

        $company_id = Input::get('company_id');
        $old = Input::get('old');
        $plans = Operationsplanlist::where(['company_id' => $company_id, 'status' => 'active'])->whereIn('type', ['MI'])->get();
        $options = '';
        foreach ($plans as $plan) {
            if (!empty($old) && trim($plan->plan_name) == $old) {
                $options .= '<option value="' . trim($plan->plan_name) . '" data-plan_id="' . $plan->id . '"  selected="selected">' . trim($plan->plan_name) . '</option>';
            } else {
                $options .= '<option value="' . trim($plan->plan_name) . '" data-plan_id="' . $plan->id . '">' . trim($plan->plan_name) . '</option>';
            }
        }
        return $options;
    }

    public function updateStatus()
    {
        $this->middleware('permission:update_operation');
        $meridian = array();
        $meridian = explode('-', Input::get('hours'));
        $call_date = null;
        if (Input::get('call_date_time') != NULL)
            $call_date = Input::get('call_date_time');
        if (isset($meridian[0]) && !empty($meridian[0]))
            $call_date .= ' ' . $meridian[0];
        if (Input::get('minutes') != NULL)
            $call_date .= ':' . Input::get('minutes');
        if (isset($meridian[1]) && !empty($meridian[1]))
            $call_date .= ' ' . $meridian[1];
        if (!empty($call_date)) {
            $call_date = (new \DateTime($call_date))->format('Y-m-d H:i:s');
        }
        if (is_array(Input::get('operation_id'))) {
            foreach (Input::get('operation_id') as $operation_id) {
                $operation = MotorLmsOperation::find($operation_id);
                $actionHistory = new OperationActionHistory;
                $actionHistory->operation_id = $operation->operation_id;
                $actionHistory->from_status = $operation->status;
                $actionHistory->to_status = Input::get('status');
                $actionHistory->from_sub_status = $operation->sub_status;
                $actionHistory->to_sub_status = !empty(Input::get('sub_status')) ? Input::get('sub_status') : 0;
                $actionHistory->updated_by = Auth::admin()->user()->id;
                $actionHistory->comments = Input::get('comments');
                $actionHistory->call_dttm = $call_date;
                $actionHistory->type = 'MOT';
                $actionHistory->save();
                $operation->status = Input::get('status');
                $operation->sub_status = !empty(Input::get('sub_status')) ? Input::get('sub_status') : 0;
                $operation->call_dttm = $call_date;
                //$operation->date_of_issuance = Input::get('date_of_issuance');
                if (!empty(Input::get('date_of_issuance'))) {
                    $operation->date_of_issuance = (new \DateTime(Input::get('date_of_issuance')))->format('Y-m-d H:i:s');

                }
                if (!empty(Input::get('lapsed_date'))) {
                    $operation->lapsed_date = (new \DateTime(Input::get('lapsed_date')))->format('Y-m-d');
                }
                $operation->save();
            }
        } else {
            $operation = MotorLmsOperation::find(Input::get('operation_id'));
            $actionHistory = new OperationActionHistory;
            $actionHistory->operation_id = $operation->operation_id;
            $actionHistory->from_status = $operation->status;
            $actionHistory->to_status = Input::get('status');
            $actionHistory->from_sub_status = $operation->sub_status;
            $actionHistory->to_sub_status = !empty(Input::get('sub_status')) ? Input::get('sub_status') : 0;
            $actionHistory->updated_by = Auth::admin()->user()->id;
            $actionHistory->comments = Input::get('comments');
            $actionHistory->call_dttm = $call_date;
            $actionHistory->type = 'MOT';
            $actionHistory->save();
            $operation->status = Input::get('status');
            $operation->sub_status = !empty(Input::get('sub_status')) ? Input::get('sub_status') : 0;
            $operation->call_dttm = $call_date;
            if (!empty(Input::get('date_of_issuance'))) {
                $operation->date_of_issuance = Input::get('date_of_issuance');

            }
            if (!empty(Input::get('lapsed_date'))) {
                $operation->lapsed_date = (new \DateTime(Input::get('lapsed_date')))->format('Y-m-d');
            }
            $operation->save();
        }

        return json_encode(['status' => 1, 'message' => 'success']);
    }

    public function updateAssignee()
    {
        checkUserCapablities(['operations_update_assignee']);
        $operation_ids = explode(',', Input::get('operation_id'));
        foreach ($operation_ids as $operation_id) {
            $operation = MotorLmsOperation::find($operation_id);
            $assignmentHistory = new OperationAssignHistory;
            $assignmentHistory->operation_id = $operation_id;
            $assignmentHistory->from_assignee = $operation->assignee;
            $assignmentHistory->from_assignee_group = 0;
            $assignmentHistory->to_assignee = Input::get('user_id');
            $assignmentHistory->to_assignee_group = 0;
            $assignmentHistory->updated_by = Auth::admin()->user()->id;
            $assignmentHistory->type = 'MOT';
            $assignmentHistory->save();
            $operation->assignee = Input::get('user_id');
            $operation->save();
        }
        return json_encode(['status' => 1, 'message' => 'User assigned successfully']);
    }

    public function getSubStatus()
    {
        $id = Input::get('status_id');
        $stlist = '';
        if (!empty($id)) {
            $statuslist = LmsStatus::where('parent_status', $id)->get();
            //echo '<pre>';print_r($statuslist); die;
            if (!empty($statuslist)) {
                foreach ($statuslist as $status) {
                    # code...
                    $stlist .= '<option value="' . $status->status_id . '">' . $status->name . '</option>';
                }
            }


        }
        echo $stlist;
    }

    public function updateLeadOperationStatus(Request $request)
    {
        $this->middleware('permission:update_operation');
        $operation_ids = $request->get('operation_id');
        $status = $request->get('lead_action');
        $comments = $request->get('comments');
        if (is_array($operation_ids)) {
            foreach ($operation_ids as $operation_id) {
                $operation = HealthLmsOperation::find($operation_id);
                $operation->status = $status;
                if(!empty($comments)) {
                    if(!empty($operation->op_comment)){
                      $json_arr = json_decode($operation->op_comment,1);
                      $json_arr[] = ['status'=>$status,'comment'=>$comments];
                    }else{
                        $json_arr[] = ['status'=>$status,'comment'=>$comments];
                    }
                    $operation->op_comment = json_encode($json_arr);
                }
                $operation->save();
            }
        } else {
            $operation = HealthLmsOperation::find($operation_ids);
            $operation->status = $status;
            if(!empty($comments)) {
                if(!empty($operation->op_comment)){
                  $json_arr = json_decode($operation->op_comment,1);
                  $json_arr[] = ['status'=>$status,'comment'=>$comments];
                }else{
                    $json_arr[] = ['status'=>$status,'comment'=>$comments];
                }
                $operation->op_comment = json_encode($json_arr);
            }
            $operation->save();
        }
        return ['status' => 1, 'message' => 'success'];
    }

    public function myLeadStatus()
    {
        $lead_type = !empty(Input::get('lead_type')) ? Input::get('lead_type') : 2;
        if ($lead_type == 2) {
            $module = 'motor_operations_my_leads';
        } elseif ($lead_type == 1) {
            $module = 'motor_operations_all_leads_my_leads';
        }
        checkUserCapablities([$module]);
        $q = Input::get('q');
        $date_range = Input::get('date');
        $date_range1 = Input::get('date_of_payment');
        $date_range2 = Input::get('date_of_issuance');
        $search_status = Input::get('search_status');
        $search_lead_operation_status = Input::get('lead_operation_status');
//        echo $search_lead_operation_status;die;
        $search_sub_status = Input::get('search_sub_status');
        $search_call_date = Input::get('search_call_date');
        $booked_by = Input::get('booked_by');
        $system = Input::get('system');
        $utm_source = Input::get('utm_source');
        $utm_term = Input::get('utm_term');
        $utm_medium = Input::get('utm_medium');
        $utm_campaign = Input::get('utm_campaign');
        $sort = !empty(Input::get('sort')) ? Input::get('sort') : 'created_at';
        $order = !empty(Input::get('order')) ? Input::get('order') : 'desc';
        $filter = Input::all();
        $status = LmsStatus::wherein('status_group', ['lms_operations', 'operation_sub_status', 'lms_operations_dttm'])->get();
        $users = Admin::wherein('role', Config::get('app.motor_lms_operations_role'))->get();
        $u = [];
        $stlist = '<option value="">Select Sub Status</option>';
        if (!empty($search_status)) {
            $statuslist = LmsStatus::where('parent_status', $search_status)->get();
            if (!empty($statuslist)) {
                foreach ($statuslist as $substatus) {
                    if ($substatus->status_id == $search_sub_status) {
                        $stlist .= '<option value="' . $substatus->status_id . '" selected>' . $substatus->name . '</option>';
                    } else {
                        $stlist .= '<option value="' . $substatus->status_id . '">' . $substatus->name . '</option>';
                    }
                }
            }
        }
        foreach ($users as $user) {
            $u[$user->id] = $user->name;
        }
        $s = [];
        foreach ($status as $statu) {
            $s[$statu->status_id] = $statu->name;
        }
//        $users_all=Admin::where(['status'=>'Active'])->get();
        if (Cache::has('teams_of_' . Auth::admin()->user()->id)) {
            $teams = Cache::get('teams_of_' . Auth::admin()->user()->id);
            $termTeams = $this->filterTeamsByTeamTypes($teams, 1);
//        dd($termTeams);
            $users_all = [];
            $users_id = [];
            foreach ($termTeams as $team) {
                $users_all = array_merge($this->getTeamMembers($team['id']), $users_all);
            }
        } else {
            $users_all = Cache::get('users_of_' . Auth::admin()->user()->id);
        }
//dd($users_all);
        foreach ($users as $user) {
            $u[$user['id']] = $user['name'];
        }

        $operations = LmsOperation::select(['motor_lms_operations.*', 'companies.company_name', 'admins.name as booked_by_name']);
        // $operations=LmsOperation::select(['motor_lms_operations.*','companies.company_name']);
        if ($lead_type == 2) {
            $operations = $operations->where(['motor_lms_operations.booked_by' => Auth::admin()->user()->id]);
        } elseif ($lead_type == 1) {
            /*$reportees=Reportees::where('user_id',Auth::admin()->user()->id)->first();
            $show_all_leads=!empty($reportees->show_all_leads)?$reportees->show_all_leads:0;
            if (!empty($reportees->reported_user_id))
                $reportees=explode(',',$reportees->reported_user_id);
            if ($show_all_leads!=1) {*/
            foreach ($users_all as $item) {
                $users_id[] = $item['id'];
            }
//            $users_id[]=Auth::admin()->user()->id;
            if (!empty($users_id)) {
                $operations = $operations->wherein('motor_lms_operations.booked_by', $users_id);
                /*$users_all=Admin::where(['status'=>'Active'])->wherein('id',$reportees)->get();*/
            }
//            }
        }
        if (!empty($q)) {
            $operations = $operations->where(function ($query) use ($q) {
                return $query->where('motor_lms_operations.proposer_name', 'like', '%' . $q . '%')
                    ->orwhere('motor_lms_operations.lead_id', 'like', '%' . $q . '%')
                    ->orwhere('motor_lms_operations.proposer_email', 'like', '%' . $q . '%')
                    ->orwhere('motor_lms_operations.proposer_mobile', 'like', '%' . $q . '%')
                    ->orwhere('motor_lms_operations.proposer_alternate_mobile', 'like', '%' . $q . '%')
                    ->orwhere('motor_lms_operations.insured_name', 'like', '%' . $q . '%')
                    ->orwhere('motor_lms_operations.application_number', 'like', '%' . $q . '%');
            });
        }
        if (!empty($date_range)) {
            $dates = explode(' - ', $date_range);
            $from = $dates[0] . ' 00:00:00';
            $to = $dates[1] . ' 23:59:59';
            $operations = $operations->where('motor_lms_operations.created_at', '>=', $from)->where('motor_lms_operations.created_at', '<=', $to);
        }
        if (!empty($date_range1)) {
            $date = explode(' - ', $date_range1);
            $from = $date[0];
            $to = $date[1];
            $operations = $operations->where('motor_lms_operations.date_of_payment', '>=', $from)->where('motor_lms_operations.date_of_payment', '<=', $to);
        }
        if (!empty($date_range2)) {
            $date = explode(' - ', $date_range2);
            $from = $date[0];
            $to = $date[1];
            $operations = $operations->where('motor_lms_operations.date_of_issuance', '>=', $from)->where('motor_lms_operations.date_of_issuance', '<=', $to);
        }
        if (!empty($search_call_date)) {
            $dates = explode(' - ', $search_call_date);
            $from = $dates[0] . ' 00:00:00';
            $to = $dates[1] . ' 23:59:59';
            $operations = $operations->where('motor_lms_operations.call_dttm', '>=', $from)->where('motor_lms_operations.call_dttm', '<=', $to);
        }
        if (!empty($search_status)) {
            if (is_array($search_status)) {
                array_filter($search_status);
                $operations = $operations->wherein('motor_lms_operations.status', $search_status);
            } else {
                $operations = $operations->where(['motor_lms_operations.status' => $search_status]);
            }
        }
        if (!empty($search_lead_operation_status)) {
            if (is_array($search_lead_operation_status)) {
                foreach ($search_lead_operation_status as $k => $search_lead_operation_statu) {
                    $operations = $operations->where(['motor_lms_operations.' . $k => $search_lead_operation_statu]);
                }
            }
        }
        if (!empty($search_sub_status)) {
            $operations = $operations->where(['motor_lms_operations.sub_status' => $search_sub_status]);
        }
        if (!empty($booked_by)) {
            $operations = $operations->where(['motor_lms_operations.booked_by' => $booked_by]);
        }
        if (!empty($system)) {
            $operations = $operations->where(['motor_lms_operations.system' => $system]);
        }

        $currentUser_utm = "";
        if (!empty($this->currentUser->utm_source)) {
            $currentUser_utm = explode(',', $this->currentUser->utm_source);
        }

        if (!empty($this->role->utm_source)) {
            $currentUser_utm = explode(',', $this->role->utm_source);
        }

        $common_utm_source = array();
        if (!empty($utm_source)) {
            if (isset($currentUser_utm) && is_array($currentUser_utm) && count($currentUser_utm) > 0) {
                $common_utm_source = array_intersect($utm_source, $currentUser_utm);
            }
        }

        if (count($common_utm_source) > 0) {
            $utm_source = $common_utm_source;
        } else if (!empty($currentUser_utm)) {
            $utm_source = $currentUser_utm;
        }

        if (!empty($utm_source)) {
            if (in_array('Empty', $utm_source)) {
                $operations = $operations->where(function ($q) use ($utm_source) {
                    return $q->where('motor_lms_operations.utm_source', '=', '')
                        ->orwhereIn('motor_lms_operations.utm_source', $utm_source);
                });
            } else {
                $operations = $operations->where(function ($q) use ($utm_source) {
                    return $q->whereIn('motor_lms_operations.utm_source', $utm_source);
                });
            }
        }

        if (!empty($utm_term)) {
            $operations = $operations->where(function ($q) use ($utm_term) {
                return $q->where('motor_lms_operations.utm_term', '=', $utm_term);
            });
        }

        if (!empty($utm_medium)) {
            $operations = $operations->where(function ($q) use ($utm_medium) {
                return $q->where('motor_lms_operations.utm_medium', '=', $utm_medium);
            });
        }

        if (!empty($utm_campaign)) {
            $operations = $operations->where(function ($q) use ($utm_campaign) {
                return $q->where('motor_lms_operations.utm_medium', '=', $utm_campaign);
            });
        }


        $operations = $operations->join('companies', 'motor_lms_operations.insurer_id', '=', 'companies.company_id')
            ->join('admins', 'motor_lms_operations.booked_by', '=', 'admins.id')
            ->orderby('motor_lms_operations.' . $sort, $order);
        if (isset($filter['download']) && $filter['download'] == 'yes') {
            $checked = null;
            if (!empty($filter['checked'])) {
                $checked = explode(',', $filter['checked']);
                $operations = $operations->wherein('motor_lms_operations.operation_id', $checked);
            }
            $operations = $operations->get();
            \Excel::create('Operations Lead Status Report - ' . date('Y-m-d H:i:s'), function ($excel) use ($operations, $s) {
                $excel->sheet('Operations Lead Status Sheet', function ($sheet) use ($operations, $s) {
                    $sheet->loadView('cms::operations.table')->with(['operations' => $operations, 'status_array' => $s]);
                });
            })->export('xls');

        }

        $all_users = Admin::select(['id', 'name', 'email'])->get()->toArray();
        $operations = $operations->paginate(10);
        $operations->setPath('lead-status');
        $operations->appends(Input::except('page'));
        return view('cms::operations.my-lead-status')->with(['operations' => $operations, 'status' => $status, 'users' => $users, 'users_all' => $users_all, 'user_array' => $u, 'status_array' => $s, 'sub_status' => $stlist, 'all_users' => $all_users]);
    }

    public function getPreviousInsurers()
    {
        $insurers = [];
        if (Input::has('company_id') && Input::get('company_id') == 63) {
            $insurers = DB::table('raw_kotak_insurers')->select('insurer_name')->orderBy('insurer_name', 'ASC')->get();
        } elseif (Input::has('company_id') && Input::get('company_id') == 37) {
            $insurers = DB::table('raw_hdfc_insurer_list')->select('InsurerName as insurer_name')->where('status', '=', 1)->orderBy('InsurerName', 'ASC')->get();
        }

        return ['status' => 1, 'message' => 'success', 'insurers' => $insurers];
    }

    public function otherLeadsListing()
    {
        $selectedId = "";
        $selectedName = "";

        $leads = $this->getLeadsOthers();
        $lmsStatus = self::lmsStatus();
        $statusArray = [];
        foreach ($lmsStatus as $status_id => $status_name) {
            $statusArray[$status_id] = $status_name->name;
        }
        $teamMember = $this->getTeamMember();

        $allUsers = [];
        $u = [];
        foreach ($teamMember as $user_id => $item) {
            $allUsers[$item->id] = $item->name;
            $u[] = ['label' => $item->name, 'value' => $item->id];
            if ($item->id == Input::get('uid')) {
                $selectedId = $item->id;
                $selectedName = $item->name;
            }
        }

        $this->currentLeadType = 1;
        $this->manageStatusData = ManageStatus::all();

        $leads = $leads->paginate(20);
        $leads->setPath('others-leads');
        $leads->appends(Input::except('page'));

        $hierarchy = 0;
        $agent_id = $this->currentUser->id;
        $hierarchy_option = DB::select(DB::raw("SELECT user_id,hierarchy FROM `team_hierarchy` where user_id =$agent_id  ORDER BY id DESC limit 1"));
        if (count($hierarchy_option) > 0) {
            $hierarchy = $hierarchy_option[0]->hierarchy;
        }

        return view('cms::mass-leads.other-index')->with(['leadslist' => $leads, 'lmsstatus' => $lmsStatus, 'users' => $allUsers, 'activeUsers' => $u, 'current_lead_type' => $this->currentLeadType, 'status_array' => $statusArray, 'manage_status' => $this->manageStatusData, 'roles_data' => $this->role->roles_id, 'selectedName' => $selectedName, 'selectedId' => $selectedId, 'agent_id' => $agent_id, 'hierarchy' => $hierarchy]);
    }

    public function canSeeFullHierarchy()
    {
        if (in_array($this->currentUser->role, [2, 36, 32])) {
            return true;
        }
        return false;
    }

    public function getTeamMember($agent_id = "")
    {
        if ($agent_id == "") {
            $agent_id = $this->currentUser->id;
        }
        $cache_key = self::CACHE_KEY . 'getTeamMember1' . $agent_id;
        if (Cache::has($cache_key)) {
            $user_data = Cache::get($cache_key);
        } else {

            if ($this->canSeeFullHierarchy()) {
                $hierachy_option = DB::select(DB::raw("SELECT DISTINCT user_id,id,hierarchy FROM `team_hierarchy` ORDER BY id DESC"));
            } else {
                $hierachy_option = DB::select(DB::raw("SELECT DISTINCT user_id,id,hierarchy FROM `team_hierarchy` where hierarchy like '%|" . $agent_id . "|%' ORDER BY id DESC"));
            }
            $user_arr = [];
            foreach ($hierachy_option as $u) {
                $user_arr[] = $u->user_id;
            }
            $user_data = Admin::whereIn('id', $user_arr)->where('status', "Active")->orderby('name', 'ASC')->get();

            $expiresAt = Carbon::now()->addMinutes(1440);
            Cache::put($cache_key, $user_data, $expiresAt);
        }
        return $user_data;
    }

    public function getLeadsOthers()
    {
        $product = @Input::get('product');
        $called_date_range = @Input::get('called_date_range');
        $q = @Input::get('q');
        $uid = @Input::get('uid');
        $lead_action = @Input::get('lead_action');
        $data = new OtherLeads;
        if (!$this->canSeeFullHierarchy()) {
            $data = $data->where('utm_source', '!=', 'TEP');;
        }
        if (isset($product) && $product != "") {
            $product_code = $this->product_type[$product];
            $data = $data->where('product', '=', $product_code);
        }

        if (isset($lead_action) && $lead_action != "") {
            $data = $data->where('status', '=', $lead_action);
        }

        if ($this->canSeeFullHierarchy()) {
            if (isset($uid) && $uid != "") {
                $data = $data->where('hierarchy', 'LIKE', "%|$uid|%");
            }
        } else {
            if (isset($uid) && $uid != "") {
                $data = $data->where('hierarchy', 'LIKE', "%|$uid|%");
                $data = $data->where('hierarchy', 'LIKE', "%|" . $this->currentUser->id . "|%");
            } else {
                $data = $data->where('hierarchy', 'LIKE', "%|" . $this->currentUser->id . "|%");
            }
        }

        if (isset($q) && $q != "") {
            $data = $data->where('name', 'LIKE', "%$q%");
            $data = $data->orWhere('email', 'LIKE', "%$q%");
        }

        if (isset($called_date_range) && $called_date_range != "") {
            $called_date_range_arr = explode(" - ", $called_date_range);
            $from = trim($called_date_range_arr[0]);
            $to = trim($called_date_range_arr[1]);
            $data = $data->whereBetween('created_at', [$from . ' 00:00:00', $to . ' 23:59:59']);
        }


        $order = @Input::get('leadid');
        if (isset($order) && $order != "") {
            $order = trim($order);
            if (in_array($order, ['asc', 'desc'])) {
                $data = $data->orderby('id', trim($order));
            } else {
                $data = $data->orderby('id', 'DESC');
            }
        } else {
            $data = $data->orderby('id', 'DESC');
        }

        //echo getRawQueriesInLaravel($data);

        return $data;

    }


    public function updateOthersLeads()
    {
        $call_date = Input::get('call_date');
        $ids = explode(',', Input::get('leads_id'));
        $ids = array_filter($ids);

        if (!empty($ids) && Input::get('lead_action') != "") {
            foreach ($ids as $id) {
                # code...
                $leads = OtherLeads::find($id);
                $leads->comments = Input::get('comments');
                if (!empty($call_date)) {
                    $leads->call_date_time = (new \DateTime($call_date))->format('Y-m-d H:i:s');
                }
                $leads->status = Input::get('lead_action');
                $leads->save();
            }
            return array('status' => 'success');
        } else {
            return array('status' => 'failed');
        }
    }

    public static function createLead($args)
    {
        $lead = new OtherLeads();
        $lead->name = $args['name'];
        $lead->product = $args['product'];
        $lead->email = isset($args['email']) ? $args['email'] : 'unknow@unknown.com';
        $lead->phone = isset($args['mobile']) ? $args['mobile'] : 9999999999;
        $lead->status = 0;
        $lead->utm_source = 'referral';
        $lead->agent_id = $args['agent_id'];
        $lead->hierarchy = $args['hierarchy'];
        $lead->raw_data = json_encode($args);
        $lead->save();
        return $lead;
    }

    public static function createBooking($args)
    {
        //pr($args);
        $operationCheckPolicy = OtherOperation::where('insurer_id', $args['insurer_id'])
            ->where('policy_number', $args['policy_number'])
            ->where('product', $args['product'])->get();

        if ($operationCheckPolicy->count() > 0) {
            $status = 107;
        } else {
            $status = config('app.status_WIP');
        }
        $operation = new OtherOperation;
        $operation->lead_id = $args['lead_id'];
        $operation->name = $args['name'];
        $operation->email = isset($args['email']) ? $args['email'] : 'unknow@unknown.com';
        $operation->mobile = isset($args['mobile']) ? $args['mobile'] : 9999999999;
        $operation->insurer_id = @$args['insurer_id'];
        $operation->tp_premium = @$args['tp_premium'];
        $operation->od_premium = $args['od_premium'];
        $operation->final_premium = $args['final_premium'];
        $operation->policy_type = $args['policy_type'];
        $operation->plan_type = $args['plan_type'];
        $operation->policy_number = $args['policy_number'];
        $operation->policy_booking_date = @$args['policy_booking_date'];
        $operation->policy_doc = "";
        $operation->product = $args['product'];
        $operation->utm_source = @$args['utm_source'];
        $operation->agent_id = $args['agent_id'];
        $operation->hierarchy = $args['hierarchy'];
        $operation->updated_by = $args['agent_id'];
        $operation->status = $status;
        if (@$args['utm_source'] == 'TEP') {
            $operation->booked_by = 33;
        } else {
            $operation->booked_by = $args['agent_id'];
        }

        $operation->policy_start_date = $args['policy_start_date'];
        $operation->comments = "Import";
        $operation->raw_data = json_encode($args);
        $operation->save();
        return $operation;
    }

    public static function createActionHistory($args)
    {
        $actionHistory = new OperationActionHistory;
        $actionHistory->operation_id = $args['operation_id'];
        $actionHistory->from_status = 0;
        $actionHistory->to_status = $args['operation_status'];
        $actionHistory->from_sub_status = 0;
        $actionHistory->to_sub_status = 0;
        $actionHistory->call_dttm = (new \DateTime(date('Y-m-d H:i:s', strtotime('+1 day'))))->format('Y-m-d H:i:s');
        $actionHistory->type = $args['product'];
        $actionHistory->updated_by = $args['agent_id'];
        $actionHistory->save();
    }

}
