<?php
namespace App\modules\backend\cms\Models;

use Illuminate\Database\Eloquent\Model;
class Companies extends Model  {

	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'companies';

	/**
	 * The table key used by the model.
	 *
	 * @var string
	 */
	protected $primaryKey = 'company_id';

	public function details()
    {
        return $this->hasOne('App\modules\backend\cms\Models\CompanyDetail','company_id');
    }

    public function leadership()
    {
        return $this->hasMany('App\modules\backend\cms\Models\Leadership','company_id');
    }

    public function termPlans(){
	    return $this->hasMany('App\modules\backend\cms\Models\InsurancePlan','company_id');
    }
    public function healthPlans(){
	    return $this->hasMany('App\modules\backend\cms\Models\Healthplan','company_id');
    }

    public function bcBills(){
	    return $this->hasMany('App\modules\backend\cms\Models\BcBilling','company_id');
    }

    public function brandingBills(){
        return $this->hasMany('App\modules\backend\cms\Models\BrandingBilling','company_id');
    }
}

			