<?php

namespace App\modules\backend\cms\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * File: HealthLmsOperation.php
 * Date: 02/04/2017
 * Time: 10:33 AM
 * Author: Sainesh Mamgain
 * Email: saineshmamgain@gmail.com
 */
class HealthLmsOperation extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'health_lms_operations';

    /**
     * The table key used by the model.
     *
     * @var string
     */
    protected $primaryKey = 'operation_id';

    public function lmsHealth()
    {
        return $this->belongsTo(\App\modules\backend\cms\Models\AllLeads::class, 'lead_id', 'id');
    }

    public function plan()
    {
        return $this->belongsTo(\App\modules\backend\cms\Models\Operationsplanlist::class, 'plan_id');
    }

    public function getWeightedPremium($usedDiscountedLink = 0)
    {
        $premium = $this->premium;
        $plan = $this->plan()->first();
        $weightage = null;
        $service_tax = null;
        $date = new \DateTime($this->date_of_payment);
        if (!empty($plan)) {
            $service_tax = $plan->serviceTax()->where(function ($query) use ($date) {
                return $query->where('product_configs_service_tax.start_date', '<=', $date->format('Y-m-d'))->where('product_configs_service_tax.end_date', '>=', $date->format('Y-m-d'));
            })->get();

            $weightage = $plan->weightage()->where(function ($query) use ($date) {
                return $query->where('product_configs.start_date', '<=', $date->format('Y-m-d'))->where('product_configs.end_date', '>=', $date->format('Y-m-d'));
            })->get();
        }

        $planWeightage = 100;
        $planServicetax = 18;
        $discount_weightage = 0;

        if (!empty($weightage) && $weightage->count() > 0) {
            $weightage = $weightage[0];
            $planWeightage = $weightage->weightage;
            if ($weightage->discount_link_available == 1 && $usedDiscountedLink == 1 && $weightage->discount_weightage > 0) {
                $planWeightage = $weightage->discount_weightage;
                $discount_weightage = 1;
            }
        }

        if (!empty($service_tax) && $service_tax->count() > 0) {
            $service_tax = $service_tax[0];
            $planServicetax = $service_tax->service_tax;
        }

        $net_premium = $premium / (1 + ($planServicetax / 100));
        $fector_2 = $this->policy_term;
        if($this->paying_mode=="Yearly"){
            $fector_1 = 1;
        }
        if($this->paying_mode=="Half Yearly"){
            $fector_1 = 2;
        }
        if($this->paying_mode=="Quarterly"){
            $fector_1 = 4;
        }
        if($this->paying_mode=="Monthly"){
            $fector_1 = 12;
        }
        if($this->paying_mode=="One Time"){
            $fector_1 = 1;
            $fector_2 = 1;
        }

        $net_premium = $net_premium/($fector_1*$fector_2);


        if($discount_weightage==0 && $this->is_discounted==1){
            $net_weighted_premium = ($net_premium * 80) / 100;
        }else{
            $net_weighted_premium = ($net_premium * $planWeightage) / 100;
        }
        //pr($this);
        //pr($this->policy_term);
        //pr($this->paying_mode);die;

        return round($net_weighted_premium);
    }

    public function getNetPremium()
    {
        $premium = $this->premium;
        $plan = $this->plan()->first();
        $service_tax = null;
        $date = new \DateTime($this->date_of_payment);
        if (!empty($plan)) {
            $service_tax = $plan->serviceTax()->where(function ($query) use ($date) {
                return $query->where('product_configs_service_tax.start_date', '<=', $date->format('Y-m-d'))->where('product_configs_service_tax.end_date', '>=', $date->format('Y-m-d'));
            })->get();
        }
        $planServicetax = 18;
        if (!empty($service_tax) && $service_tax->count() > 0) {
            $service_tax = $service_tax[0];
            $planServicetax = $service_tax->service_tax;
        }

        $net_premium = $premium / (1 + ($planServicetax / 100));

        return round($net_premium);
    }

    public function getComments()
    {
        $history = OperationActionHistory::where([
            'to_status' => $this->status,
            'to_sub_status' => $this->sub_status,
            'operation_id' => $this->operation_id,
            'type' => 'HI'
        ])->orderBy('created_at', 'DESC')->first();

        return (!empty($history->comments)) ? $history->comments : '';
    }
}