<?php
namespace App\modules\backend\cms\Models;
use Illuminate\Database\Eloquent\Model;

/**
 * File: TeamManagement.php
 * Date: 21/3/17
 * Author: Sainesh Mamgain
 * Email: sainesh.mamgain@comparepolicy.com
 *
 */

class TeamManagement extends Model{

    protected $table='team_management';


    protected $primaryKey='id';

    public $timestamps = true;

    public function parents(){

        return $this->belongsTo('App\modules\backend\cms\Models\TeamManagement','parent_id');
    }

    public function children(){

        return $this->hasMany('App\modules\backend\cms\Models\TeamManagement','parent_id');
    }

    public function teamTypes(){

        return $this->belongsToMany('App\modules\backend\cms\Models\TeamType','teams_team_type','team_management_id','team_type_id');
    }

    public function teamLead(){

        return $this->belongsTo('App\modules\backend\rbac\Models\Admin','team_lead');
    }

    public function members(){
        return $this->hasMany('App\modules\backend\rbac\Models\Admin','team_id');
    }

    public function incentives(){
        return $this->hasMany('App\modules\backend\cms\Models\Incentive','team_id');
    }
}