@extends('admin/layout')
@section('content')
	<div class="row-fluid">
		<div class="span12">
			@if (Session::has('message'))F
			<div class="alert alert-info">{{ Session::get('message') }}</div>
			@endif
			<h4 class="widgettitle nomargin shadowed">Filter</h4>
			<div class="widgetcontent bordered shadowed">
				<div class="row-fluid">
					@include('common.lead_form_search',['lmsstatus'>$lmsstatus,'selectedName'=>$selectedName,'activeUsers'=>$activeUsers])
				</div>
				<div class="row-fluid">
					@can('lead_assignment')
					<a data-toggle="modal" title="Add this item" class="open-assignDialog assignleads   btn btn-success" href="#assignDialog">Assign Selected Leads</a>
					@endcan
				</div>
			</div>

			<div class="widgetcontent">
				<div class="double-scroll">
					<table class="table table-bordered" id="leadtable">
						<thead>
							<tr>
								<th class="head0 nosort"><input type="checkbox" class="checkall"/></th>
								<th class="head0">Lead Id
									<br><span style="color:green">Assignee</span>
									<br><span style="color:green">[UtmSource]</span>
									<br><span style="color:blue">[UtmTerm]</span>
								</th>
								<th class="head0">Name<span style="color:green"></span></th>
								<th class="head0">Phone</th>
								<th class="head0">Email</th>
								<th class="head0">Entry Date</th>
								<th class="head0">Product</th>
								<th class="head0">Status</th>
								<th class="head0">Actions</th>
							</tr>
						</thead>
						<tbody>
						<?php ?>
						@if(isset($leadslist) and !empty($leadslist))
							@foreach($leadslist as $key => $value)
								<?php $json_data = json_decode($value->raw_data,1);?>
								<tr>
									<td class="aligncenter">
                                        <span class="center">
                                            <input type="checkbox" class="leadselection" value="{{ $value->id }}"
												   actionid={{ $value->id }} />
                                        </span>
									</td>
									<td>{{ $value->id }}
										<span id="assignee{{$value->id}}">
						  					@if($value->agent_id)
												<br><span style="color:green">
													@if(isset($users[$value->agent_id]))
														{{str_replace("--","",$users[$value->agent_id])}}
													@elseif($value->agent_id==6)
														{{'Lead Assignment'}}
													@else
														{{$value->agent_id}}
													@endif

												</span>
											@endif
						  				</span>
										@if(!empty($value->utm_source ))
											<br/><span style="color:green">[ {{$value->utm_source}}]</span>
										@endif
										@if(!empty($value->utm_term ))
											<br/><span style="color:blue">[{{$value->utm_term}}]</span>
										@endif
									</td>
									<td>{{ !empty($value->name)?$value->name:''}}</td>
									<td>{{ !empty($value->phone)?$value->phone:''}}</td>
									<td>{{ !empty($value->email)?$value->email:''}}</td>
									<td>{{!empty($value->created_at)?$value->created_at:''}}</td>
									<td>{{!empty($json_data['body'])?$json_data['body']:''}}</td>
									<td>{{!empty($value->product)?$value->product:''}}</td>
									<td>{{!empty($value->status)?$lmsstatus[$value->status]->name:''}}</td>
									<td>
										@if($value->status !=40)
											@can('update_lead')
												<a data-toggle="modal" data-id="{{$value->id}}"
												   class="open-AddBookDialog badge badge-success individualupdateleads"
												   data-status="{{$value->status}}" href="#addBookDialog"
												   title="Update">U</a>&nbsp;&nbsp;
											@endcan
										@endif&nbsp;&nbsp;
										<a data-toggle="modal" data-id="{{$value->id}}"
										   class="badge badge-info leadhistory" href="#leadhistory"
										   title="History">H</a>&nbsp;&nbsp;
											<a href="/leads/{{$route}}/view/{{$value->id}}"
											   class="badge badge-info leadhistory"
											   title="View Lead">V</a>&nbsp;&nbsp;
										<?php
										$htmlpopup = "";
										$counter = 1;
										$leadHistory_arr = $value->leadHistory->toArray();
										$htmlpopup .= "<div id='history-".$value->id."' style='display:none;'><table border='1' style='width:100%;border:1px solid'>";
										$htmlpopup .= "<tr><td>Sr. No.</td><td>Status</td><td>Comments</td></tr>";
										if(!empty($leadHistory_arr)){
											if(isset($value->status) && $value->status !=0 && isset($status_array[$value->status])){
												$htmlpopup .= "<tr><td>".$counter."</td><td>".$status_array[$value->status]."</td><td>".$value->comments."</td></tr>";
											}
											foreach($leadHistory_arr as $leadHistory){
												if(isset($leadHistory['status']) && $leadHistory['status'] !=0 && $status_array[$leadHistory['status']])
												{
												$counter++;
												$htmlpopup .= "<tr><td>".$counter."</td><td>".$status_array[$leadHistory['status']]."</td><td>".$leadHistory['comments']."</td></tr>";
												}
											}
										}else{
											$htmlpopup .= "<tr><td colspan='3'>No History</td></tr>";
										}
										$htmlpopup .= "</table></div>";
										echo $htmlpopup;
										?>
									</td>
								</tr>
							@endforeach
						@else
							<tr>
								<td colspan="5">No Result Found!</td>
							</tr>
						@endif
						</tbody>
					</table>
				</div>
				<br/>
				<div class="pagination">
					<?php echo $leadslist->render(); ?>
				</div>
			</div>
			<div class="divider15"></div>

		</div><!--span8-->

	</div><!--row-fluid-->
	@include('common.popups',['lmsstatus'=>$lmsstatus,'activeUsers'=>$activeUsers])
@endsection

@pushOnce('inlinescripts')
<script>
	$("#updatorform").submit(function (e) {
		e.preventDefault();
		if ($("#lead_action").val() == "") {
			$("#lead_action").css("border", "1px solid red");
			return false;
		} else if ($(".statusdatebox").css("display") == 'block') {
			if ($("#lead_action option:selected").attr('attrtype') !== 'action_dttm_optional') {
				if ($("#call_date").val() == "") {
					$("#call_date").css("border", "1px solid red");
					return false;
				} else if ($("#hours").val() == "") {
					$("#hours").css("border", "1px solid red");
					return false;
				} else if ($("#minutes").val() == "") {
					$("#minutes").css("border", "1px solid red");
					return false;
				}
			}
		}

		var checkedVals = $('.leadselection:checkbox:checked').map(function () {
			return this.value;
		}).get();
		$('.bulkupdatelms').val(checkedVals);
		//bulkupdatelms
		$.post('/leads/{{$route}}/update-leads', $('form#updatorform').serialize(), function (data) {
				if (data.status == 'success') {
					$('.statusupdatemessage').html('Status Updated Successfully!');
					$('td#' + data.node).html(data.status_name);
					$('td#' + data.node).next().html(data.call_date);
					$('.close').click();
					window.location.reload();
				} else {
					$('.statusupdatemessage').html('Please select lead first!');
				}

				$('#selection2').prop('selectedIndex', 0);
				$('#comments').val('');
				$('.leadselection:checkbox').removeAttr('checked');
				$('.checkall:checkbox').removeAttr('checked');
				return false;

			},
			'json' // I expect a JSON response
		);
		setTimeout(function () {
			// Do something after 1 second
			$('.close').click();
			$('.statusupdatemessage').html('');
			//location.reload();
		}, 2000);

		// $('#addBookDialog').modal('toggle');
		return false;
	});
	$(function () {
		$('#lead_action').change(function () {
			if ($(this).val() == '40') {
				var lead_id = $('.leadselection:checkbox:checked').map(function () {
					return this.value;
				}).get();
				window.location = '{{url(sprintf('operations/%s/add/',$route))}}' + '/' + lead_id[0];
			}
		});
	});
</script>
@endPushOnce
