@extends('admin/layout')
@section('content')
	<div class="row-fluid">
		<div class="span12">
			<div class="widgetcontent">
				<div class="double-scroll">
					<div class="card shadow mb-4">
						<div class="card-header py-3">
							<h6 class="m-0 font-weight-bold text-primary">{{__("Booking")}}</h6>
						</div>
						<div class="card-body">
							<div class="table-responsive">
								<h1>Booking Id: {{$operation->operation_id}}</h1>
								@if (count($errors) > 0)
									<div class="alert alert-danger">
										<strong>Whoops!</strong> There were some problems with your input.<br>

										@foreach ($errors->all() as $error)
											<p>{{ $error }}</p>
										@endforeach

									</div>
								@endif
								@if (Session::has('message'))
									<div class="alert alert-info">{{ Session::get('message') }}</div>
								@endif

								<form action="{{url('/operations/health/update/'.$operation->operation_id)}}" method="post"
									  class="stdform stdform2">
									<div class="row-fluid">
										<input type="hidden" name="lead_id" id="lead_id" value="{{$operation->lead_id}}">
										<input type="hidden" name="booking_id" id="booking_id" value="{{$operation->operation_id}}">
										<input type="hidden" name="utm_source"
											   value="{{$operation->utm_source}}">
										<input type="hidden" name="utm_medium"
											   value="{{$operation->utm_medium}}">
										<input type="hidden" name="utm_term" value="{{@$operation->utm_term}}">
										<input type="hidden" name="utm_campaign"
											   value="{{$operation->utm_campaign}}">
										<div class="span6">
											<div class="widgetcontent bordered shadowed nopadding">
												<h4 class="widgettitle nomargin shadowed">Insurer Selected</h4>
												<p>
													<label for="insurer_id">Insurer Name</label>
                                <span class="field">
                                    <select name="insurer_id" id="insurer_id" class="select-insurer-id" required>
                                        <option value="">Choose</option>
										@foreach($companies as $company)
											<option
												value="{{$company->company_id}}" {{($operation->insurer_id==$company->company_id?'selected':'')}}>{{$company->company_name}}</option>
										@endforeach
                                    </select>
                                </span>
												</p>
												<!--<p>
													<label for="plan_name">Plan Name</label>
                                <span class="field">
                                    <select name="plan_name" id="plan_name" required>
                                        <option value="">Select Plan</option>
                                    </select>
                                </span>
												</p>-->
												<p>
													<label for="policy_type">Policy Type</label>
                                <span class="field">
                                    <select name="policy_type" id="policy_type" required>
                                        <option value="">Choose</option>
										<?php
										$policy_types = ['Regular', 'Limited', 'Single'];
										?>
										@foreach($policy_types as $policy_type)
											<option
												value="{{$policy_type}}" {{($operation->policy_type==$policy_type)?'selected':''}}>{{$policy_type}}</option>
										@endforeach
                                    </select>
                                </span>
												</p>
												<p>
													<label for="application_number">Application Number</label>
                                <span class="field">
                                        <input type="text" name="application_number" id="application_number"
											   value="{{$operation->application_number}}" required>
                                    </span>
												</p>
												<p>
													<label for="equote_number">Equote Number</label>
                                <span class="field">
                                        <input type="text" name="equote_number" id="equote_number"
											   value="{{$operation->equote_number}}">
                                    </span>
												</p>

												<p>
													<label for="policy_term">Policy Term</label>
                                <span class="field">
                                    <input type="text" name="policy_term" id="policy_term"
										   value="{{$operation->policy_term}}" required class="numberonly"
										   maxlength="2">
                                </span>
												</p>
												<p>
													<label for="policy_number">Policy Number</label>
                                <span class="field">
                                        <input type="text" readonly="readonly" disabled="disabled"
											   value="{{$operation->policy_number}}">
                                    </span>
												</p>

												<p>
													<label for="sum_insured">Sum Insured</label>
                                <span class="field">
                                    <input type="text" name="sum_insured" id="sum_insured"
										   value="{{$operation->sum_insured}}" required class="numberonly"
										   maxlength="9" max="100000000">
                                </span>
												</p>
												<p>
													<label for="premium">Premium</label>
                                <span class="field">
                                    <input type="text" name="premium" id="premium" value="{{$operation->premium}}"
										   required class="numberonly" maxlength="7" max="1000000">
                                </span>
												</p>
												<p>
													<label for="paying_mode">Paying Mode</label>
                                <span class="field">
                                    <select name="paying_mode" id="paying_mode" required>
                                        <option value="">Choose</option>
										<?php
										$modes = ['Yearly', 'Half Yearly', 'Quarterly', 'Monthly', 'One Time'];
										?>
										@foreach($modes as $mode)
											<option
												value="{{$mode}}" {{($operation->paying_mode==$mode)?'selected':''}}>{{$mode}}</option>
										@endforeach
                                    </select>
                                </span>
												</p>
												<p>
													<label for="annual_income">Annual Income</label>
                                <span class="field">
                                    <select name="annual_income" id="annual_income">
                                        <option value="">Choose</option>
										<?php
										$incomes = ['Less than 3 Lacs', '3 Lacs to 5 Lacs', '5 Lacs to 10 Lacs', '10 Lacs and above'];
										?>
										@foreach($incomes as $income)
											<option
												value="{{$income}}" {{($operation->annual_income==$income)?'selected':''}}>{{$income}}</option>
										@endforeach
                                    </select>
                                </span>
												</p>

												<p>
													<label for="dop">Date Of Payment</label>
                                <span class="field">
                                <input type="text" name="date_of_payment"
									   class="date readonly" id="date_of_payment"
									   value="{{$operation->date_of_payment}}" required readonly/>
                            </span>
												</p>
												<p>
													<label for="portability">Portability</label>
                                <span class="field">
                                <select name="portability" id="portability" required>
                                    <option value="">Select</option>
                                    <option value="no" {{$operation->portability=='no'?'selected':''}}>No</option>
                                    <option value="yes" {{$operation->portability=='yes'?'selected':''}}>Yes</option>
                                </select>
                            </span>
												</p>
												<p>
													<label for="stp_nstp">STP/NSTP</label>
                                <span class="field">
                                <select name="stp_nstp" id="stp_nstp" required>
                                    <option value="">Select</option>
                                    <option value="STP" {{$operation->stp_nstp=='STP'?'selected':''}}>STP</option>
                                    <option value="NSTP" {{$operation->stp_nstp=='NSTP'?'selected':''}}>NSTP</option>
                                </select>
                            </span>
												</p>

												<p>
													<label for="proposer_name">Remarks</label>
                                <span class="field">
                                <input type="text" name="remarks" id="remarks" value="{{$operation->remarks}}"
									   class="alpha_dash" required>
                            </span>
												</p>

												<p>
													<label for="policy_mode">Policy Mode</label>
                                <span class="field">
                                    <select name="policy_mode" id="policy_mode" required>
                                        <option value="">Select</option>
                                        <option value="Online" {{$operation->policy_mode=='Online'?'selected':''}}>Online</option>
                                        <option value="Offline" {{$operation->policy_mode=='Offline'?'selected':''}}>Offline</option>
                                    </select>
                                         </span>
												</p>

											</div>
										</div><!--span6-->
										<div class="span6">
											<div class="widgetcontent bordered shadowed nopadding">
												<h4 class="widgettitle nomargin shadowed">Proposer</h4>
												<p>
													<label for="proposer_name">Proposer Name</label>
                                <span class="field">
                                <input type="text" name="proposer_name" id="proposer_name"
									   value="{{$operation->proposer_name}}" class="alpha_dash" required>
                            </span>
												</p>
												<p>
													<label for="proposer_email">Proposer Email</label>
                                <span class="field">
                                <input type="email" name="proposer_email" id="proposer_email"
									   value="{{$operation->proposer_email}}" required>
                            </span>
												</p>
												<p>
													<label for="proposer_city">Proposer City</label>
                                <span class="field">
                                <input type="text" name="proposer_city" id="proposer_city"
									   value="{{$operation->proposer_city}}" required class="alpha_dash">
                            </span>
												</p>
												<p>
													<label for="proposer_address">Proposer Address</label>
                                <span class="field">
                                <input type="text" id="proposer_address" name="proposer_address"
									   value="{{$operation->proposer_address}}" required>
                            </span>
												</p>
												<p>
													<label for="proposer_mobile">Proposer Mobile</label>
                                <span class="field">
                                <input type="text" name="proposer_mobile" id="proposer_mobile"
									   value="{{$operation->proposer_mobile}}" class="numberonly length"
									   maxlength="10" minlength="10" required>
                            </span>
												</p>
												<p>
													<label for="proposer_alternate_mobile">Proposer Alternate
														Mobile</label>
                                <span class="field">
                                <input type="text" name="proposer_alternate_mobile"
									   value="{{$operation->proposer_alternate_mobile}}"
									   id="proposer_alternate_mobile" class="numberonly" minlength="10" maxlength="10">
                            </span>
												</p>
											</div>
										</div><!--span6-->
										<div class="span12">
											<div class="span12">
												<input type="hidden" name="_token" value="{{csrf_token()}}">
												<button type="submit" class="btn btn-primary">Submit</button>
											</div>

										</div>
									</div><!--row-fluid-->
								</form>
							</div>
						</div>
					</div>
				</div>

			</div>
			<div class="divider15"></div>

		</div><!--span8-->

	</div><!--row-fluid-->

@endsection
@pushOnce('inlinescripts')
<script>

	$('#date_of_payment').daterangepicker({
		singleDatePicker: true,
		showDropdowns: true,
		minYear: "{{date('Y', strtotime('-1 year'))}}",
		maxYear: "{{date('Y', strtotime('+1 year'))}}",
		locale: {
			format: 'YYYY-mm-dd'
		}
	}, function(start, end, label) {
		var years = moment().diff(start, 'years');
		//alert("You are " + years + " years old!");
	});
</script>
@endPushOnce