@extends('admin/layout')
@section('content')
	<div class="row-fluid">
		<div class="span12">
			<div class="widgetcontent">
				<div class="double-scroll">
					<div class="card shadow mb-4">
						<div class="card-header py-3">
							<h6 class="m-0 font-weight-bold text-primary">{{__("Booking")}}</h6>
						</div>
						<div class="card-body">
							<div class="table-responsive">
								<h1>Lead Id: {{$lead_id}}</h1>
								@if (count($errors) > 0)
									<div class="alert alert-danger">
										<strong>Whoops!</strong> There were some problems with your input.<br>

										@foreach ($errors->all() as $error)
											<p>{{ $error }}</p>
										@endforeach

									</div>
								@endif
								@if (Session::has('message'))
									<div class="alert alert-info">{{ Session::get('message') }}</div>
								@endif

								<form action="{{url('/operations/life/save/'.$lead_id)}}" method="post"
									  class="stdform stdform2">
									<div class="row-fluid">
										<input type="hidden" name="lead_id" id="lead_id" value="{{$lead_id}}">
										<input type="hidden" name="utm_source"
											   value="{{@$childLeadRawData->utm_source}}">
										<input type="hidden" name="utm_medium"
											   value="{{@$childLeadRawData->utm_medium}}">
										<input type="hidden" name="utm_term" value="{{@$childLeadRawData->utm_term}}">
										<input type="hidden" name="utm_campaign"
											   value="{{@$childLeadRawData->utm_campaign}}">
										<div class="span6">
											<div class="widgetcontent bordered shadowed nopadding">
												<h4 class="widgettitle nomargin shadowed">Insurer Selected</h4>
												<p>
													<label for="insurer_id">Insurer Name</label>
                                <span class="field">
                                    <select name="insurer_id" id="insurer_id" class="select-insurer-id" required>
                                        <option value="">Choose</option>
										@foreach($companies as $company)
											<option
												value="{{$company->company_id}}" {{(old('insurer_id')==$company->company_id?'selected':'')}}>{{$company->company_name}}</option>
										@endforeach
                                    </select>
                                </span>
												</p>
												<p>
													<label for="plan_name">Plan Name</label>
                                <span class="field">
                                        <input type="text" name="plan_name" id="plan_name"
											   value="{{old('plan_name')}}">
                                    </span>
												</p>
												<p>
													<label for="policy_type">Policy Type</label>
                                <span class="field">
                                    <select name="policy_type" id="policy_type" required>
                                        <option value="">Choose</option>
										<?php
										$policy_types = ['Regular', 'Limited', 'Single'];
										?>
										@foreach($policy_types as $policy_type)
											<option
												value="{{$policy_type}}" {{(old('policy_type')==$policy_type)?'selected':''}}>{{$policy_type}}</option>
										@endforeach
                                    </select>
                                </span>
												</p>
												<p>
													<label for="application_number">Application Number</label>
                                <span class="field">
                                        <input type="text" name="application_number" id="application_number"
											   value="{{old('application_number')}}" required>
                                    </span>
												</p>
												<p>
													<label for="equote_number">Equote Number</label>
                                <span class="field">
                                        <input type="text" name="equote_number" id="equote_number"
											   value="{{old('equote_number')}}">
                                    </span>
												</p>

												<p>
													<label for="policy_term">Policy Term</label>
                                <span class="field">
                                    <input type="text" name="policy_term" id="policy_term"
										   value="{{old('policy_term')}}" required class="numberonly"
										   maxlength="2">
                                </span>
												</p>
												<p>
                                <label for="policy_paying_term">Policy Paying Term</label>
                                <span class="field">
                                    <input type="text" name="policy_paying_term" id="policy_paying_term"
                                           value="{{old('policy_paying_term')}}" required class="numberonly"
                                           maxlength="2">
                                </span>
                            </p>
												<p>
													<label for="policy_number">Policy Number</label>
                                <span class="field">
                                        <input type="text" name="policy_number" id="policy_number"
											   value="{{old('policy_number')}}">
                                    </span>
												</p>

												<p>
													<label for="sum_insured">Sum Insured</label>
                                <span class="field">
                                    <input type="text" name="sum_insured" id="sum_insured"
										   value="{{old('sum_insured')}}" required class="numberonly"
										   maxlength="9" max="100000000">
                                </span>
												</p>
												<p>
													<label for="premium">Premium</label>
                                <span class="field">
                                    <input type="text" name="premium" id="premium" value="{{old('premium')}}"
										   required class="numberonly" maxlength="7" max="1000000">
                                </span>
												</p>
												<p>
													<label for="paying_mode">Paying Mode</label>
                                <span class="field">
                                    <select name="paying_mode" id="paying_mode" required>
                                        <option value="">Choose</option>
										<?php
										$modes = ['Yearly', 'Half Yearly', 'Quarterly', 'Monthly', 'One Time'];
										?>
										@foreach($modes as $mode)
											<option
												value="{{$mode}}" {{(old('paying_mode')==$mode)?'selected':''}}>{{$mode}}</option>
										@endforeach
                                    </select>
                                </span>
												</p>
												<p>
													<label for="annual_income">Annual Income</label>
                                <span class="field">
                                    <select name="annual_income" id="annual_income">
                                        <option value="">Choose</option>
										<?php
										$incomes = ['Less than 3 Lacs', '3 Lacs to 5 Lacs', '5 Lacs to 10 Lacs', '10 Lacs and above'];
										?>
										@foreach($incomes as $income)
											<option
												value="{{$income}}" {{(old('annual_income')==$income)?'selected':''}}>{{$income}}</option>
										@endforeach
                                    </select>
                                </span>
												</p>
												<p>
	                                <label for="tobacco">Is Tobacco User?</label>
	                                <span class="field">
	                                <select name="tobacco" id="tobacco" class="input-xxlarge" required>
	                                    <option value="">Choose</option>
	                                    <option value="yes" {{(old('tobacco')=='yes')?'selected':''}}>Yes</option>
	                                    <option value="no" {{(old('tobacco')=='no')?'selected':''}}>No</option>
	                                </select>
	                            </span>
	                            </p>
												<p>
													<label for="dop">Date Of Payment</label>
                                <span class="field">
                                <input type="text" name="date_of_payment"
									   class="date readonly" id="date_of_payment"
									   value="{{old('date_of_payment')}}" required readonly/>
                            </span>
												</p>
												<p>
                                <label for="policy_mode">Policy Mode</label>
                                <span class="field">
                                    <select name="policy_mode" id="policy_mode" required>
                                        <option value="">Select</option>
                                        <option value="Online" {{old('policy_mode')=='Online'?'selected':''}}>Online</option>
                                        <option value="Offline" {{old('policy_mode')=='Offline'?'selected':''}}>Offline</option>
                                    </select>
                                         </span>
                            </p>

												<p>
													<label for="proposer_name">Remarks</label>
                                <span class="field">
                                <input type="text" name="remarks" id="remarks" value="{{old('remarks')}}"
									   class="alpha_dash" required>
                            </span>
												</p>



											</div>
										</div><!--span6-->
										<div class="span6">
											<div class="widgetcontent bordered shadowed nopadding">
												<h4 class="widgettitle nomargin shadowed">Proposer</h4>
												<p>
													<label for="proposer_name">Proposer Name</label>
                                <span class="field">
                                <input type="text" name="proposer_name" id="proposer_name"
									   value="{{old('proposer_name')}}" class="alpha_dash" required>
                            </span>
												</p>
												<p>
													<label for="proposer_email">Proposer Email</label>
                                <span class="field">
                                <input type="email" name="proposer_email" id="proposer_email"
									   value="{{old('proposer_email')}}" required>
                            </span>
												</p>
												<p>
                                <label for="proposer_dob">Proposer DOB</label>
                                <span class="field">
                                <input type="text" name="proposer_dob" id="proposer_dob"
                                       value="{{old('proposer_dob')}}" class="datetimepickd calenderMonthYear"
                                       required>
                            </span>
                            </p>
												<p>
													<label for="proposer_city">Proposer City</label>
                                <span class="field">
                                <input type="text" name="proposer_city" id="proposer_city"
									   value="{{old('proposer_city')}}" required class="alpha_dash">
                            </span>
												</p>
												<p>
													<label for="proposer_address">Proposer Address</label>
                                <span class="field">
                                <input type="text" id="proposer_address" name="proposer_address"
									   value="{{old('proposer_address')}}" required>
                            </span>
												</p>
												<p>
													<label for="proposer_mobile">Proposer Mobile</label>
                                <span class="field">
                                <input type="text" name="proposer_mobile" id="proposer_mobile"
									   value="{{old('proposer_mobile')}}" class="numberonly length"
									   maxlength="10" minlength="10" required>
                            </span>
												</p>
												<p>
													<label for="proposer_alternate_mobile">Proposer Alternate
														Mobile</label>
                                <span class="field">
                                <input type="text" name="proposer_alternate_mobile"
									   value="{{old('proposer_alternate_mobile')}}"
									   id="proposer_alternate_mobile" class="numberonly" minlength="10" maxlength="10">
                            </span>
												</p>
											</div>
										</div><!--span6-->
										<div class="span12">
											<div class="span12">
												<input type="hidden" name="_token" value="{{csrf_token()}}">
												<button type="submit" class="btn btn-primary">Submit</button>
											</div>

										</div>
									</div><!--row-fluid-->
								</form>
							</div>
						</div>
					</div>
				</div>

			</div>
			<div class="divider15"></div>

		</div><!--span8-->

	</div><!--row-fluid-->

@endsection
@pushOnce('inlinescripts')
<script>

	$('#date_of_payment').daterangepicker({
		singleDatePicker: true,
		showDropdowns: true,
		minYear: "{{date('Y', strtotime('-1 year'))}}",
		maxYear: "{{date('Y', strtotime('+1 year'))}}",
		locale: {
			format: 'YYYY-mm-dd'
		}
	}, function(start, end, label) {
		var years = moment().diff(start, 'years');
		//alert("You are " + years + " years old!");
	});
</script>
@endPushOnce
