@extends('admin/layout')
@section('content')
	<div class="row-fluid">
		<div class="span12">
			@if (Session::has('message'))
				<div class="alert alert-info">{{ Session::get('message') }}</div>
			@endif
			<h4 class="widgettitle nomargin shadowed">Filter</h4>
			<div class="widgetcontent bordered shadowed">
				<div class="row-fluid">
					@include('common.booking_form_search',['lmsstatus'>$status,'activeUsers'=>$users_all])
				</div>
				<div class="row-fluid">
					<table class="table table-bordered">
						<thead>
						<tr>
							<th><input type="checkbox" class="checkall"></th>
							<th>Lead Id</th>
							<th>Premium</th>
							<th>Proposer Name<br>
								<span style="color: blue;">Proposer Email</span>
							</th>
							<th>Proposer Mobile</th>
							<th>Booked By/Payment Date</th>
							<th>Status</th>
							<th>Created</th>
							<th>Actions</th>
						</tr>
						</thead>
						<tbody>
						@foreach($operations as $key=>$operation)
							<tr>
								<td>
									<input id="operation_checkbox_{{$operation->operation_id}}" type="checkbox"
										   value="{{$operation->operation_id}}" class="leadselection">
								</td>
								<td>
									{{$operation->lead_id}}<br>
                  <span id="assignee-for-{{$operation->operation_id}}" style="color:green">
											@if(isset($users_all[$operation->agent_id]))
                      	{{!empty($users_all[$operation->agent_id])?str_replace("--","",$users_all[$operation->agent_id]):''}}
											@endif
									</span>
									@if($operation->utm_source!="")
										<br><span style="color:green">[{{$operation->utm_source}}]</span>
									@endif
								</td>
								<td>{{$operation->premium}}</td>
								<td>{{$operation->proposer_name}}<br>
									<span style="color: blue;">{{$operation->proposer_email}}</span>
								</td>
								<td>{{$operation->proposer_mobile}}</td>
								<td>
									{{!empty($users_all[$operation->agent_id])?str_replace("--","",$users_all[$operation->agent_id]):''}}

									/{{$operation->date_of_payment}}
								</td>
								<td>
									<span id="status-for-{{$operation->operation_id}}"></span>
									{{!empty($status_array[$operation->status])?$status_array[$operation->status]:''}}
									<br>
                                    <!--<span id="sub-status-for-{{$operation->operation_id}}"
										  style="color: green">{{!empty($status_array[$operation->sub_status])?$status_array[$operation->sub_status]:''}}</span>-->
								</td>
								<td>{{$operation->created_at}}</td>
								<td>
									@can('edit_booking')
										<a class="badge badge-info" href="{{url('operations/life/edit/'.$operation->operation_id)}}" title="Edit">E</a>
									@endcan
									@can('update_operation')
										<a data-toggle="modal" data-id="{{$operation->id}}"
										   class="open-AddBookDialog badge badge-success individualupdateleads"
										   data-status="{{$operation->status}}" href="#addBookDialog"
										   title="Update">U</a>&nbsp;&nbsp;
									@endcan
									<a class="badge badge-info"  href="{{url('operations/life/view/'.$operation->operation_id)}}" title="View">V</a>
								</td>
							</tr>
						@endforeach
						</tbody>
					</table>
				</div>
				<div class="pagination">
					<?php echo $operations->render(); ?>
				</div>
			</div>

			<div class="divider15"></div>

		</div><!--span8-->

	</div><!--row-fluid-->
	@include('common.updatestatusope',['lmsstatus'=>$lmsstatus])
@endsection

@pushOnce('inlinescripts')
<script>
	$("#updatorform").submit(function (e) {
		e.preventDefault();
		var checkedVals = $('.leadselection:checkbox:checked').map(function () {
			return this.value;
		}).get();
		$('.bulkupdatelms').val(checkedVals);
		//bulkupdatelms
		$.post('/operations/life/update-status', $('form#updatorform').serialize(), function (data) {
				if (data.status == 1) {
					$('.statusupdatemessage').html('Status Updated Successfully!');
					window.location.reload();
				} else {
					$('.statusupdatemessage').html('Please select lead first!');
				}

				//$('#selection2').prop('selectedIndex', 0);
				//$('#comments').val('');
				//$('.leadselection:checkbox').removeAttr('checked');
				//$('.checkall:checkbox').removeAttr('checked');
				return false;

			},
			'json' // I expect a JSON response
		);
		return false;
	});
</script>
@endPushOnce
