@extends('admin/layout')

@section('content')
    <div class="container-fluid">
        <div class="span12">
            <div class="widgetcontent">
                <a class="btn btn-primary writeonly" href="{{ url('/users/team-management/create') }}">Add New</a> &nbsp; &nbsp; &nbsp;
                <a class="btn btn-primary" href="{{ url('/users/team-management/') }}">View All</a>

            </div>
            <!-- if there are creation errors, they will show here -->
            @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> There were some problems with your input.<br>

                    @foreach ($errors->all() as $error)
                        <p>{{ $error }}</p>
                    @endforeach

                </div>
            @endif
            @if (Session::has('message'))
                <div class="alert alert-info">{{ Session::get('message') }}</div>
            @endif
            <h4 class="widgettitle nomargin shadowed">&nbsp;</h4>
            <div class="widgetcontent bordered shadowed nopadding">
                <form class="stdform stdform2" method="post" action="{{url('/users/team-management/create')}}" enctype="multipart/form-data">
                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                    <p>
                        <label>Parent</label>
                        <span class="field">
                            <select name="parent_id" id="parent_id">
                                <option value="">---- No Parent ----</option>
                                @foreach($parents as $parent)
                                    @if(Request::old('parent_id')==$parent->id)
                                        <option value="{{$parent->id}}" selected>{{$parent->team_name}}</option>
                                    @else
                                        <option value="{{$parent->id}}">{{$parent->team_name}}</option>
                                    @endif
                                @endforeach
                            </select>
                        </span>
                    </p>
                    <p>
                        <label>Team Name</label>
                        <span class="field">
                            <input type="text" name="team_name" value="{{Request::old('team_name')}}" id="team_name" class="input-xxlarge" required>
                        </span>
                    </p>
                    <p>
                        <label for="">Team Type</label>
                        <span class="field">
                            <select name="teamTypes[]" id="teamTypes"  class="chzn-select-type" multiple="multiple" style="width:350px;" tabindex="4" required>
								@foreach($teamTypes as $key => $teamType)
                                    <option value="{{ $teamType->id }}">{{ $teamType->team_type}}</option>
                                @endforeach
                            </select>
                        </span>
                    </p>
                    <p>
                        <label for="">Team Lead</label>
                        <span class="field">
                            <select name="team_lead" id="team_lead" required>
                                <option value="">---- SELECT ----</option>
                                @foreach($teamLeads as $teamLead)
                                    @if(Request::old('team_lead')==$teamLead->id)
                                        <option value="{{$teamLead->id}}" selected>{{$teamLead->getFullNameAttribute()}}</option>
                                    @else
                                        <option value="{{$teamLead->id}}">{{$teamLead->getFullNameAttribute()}}</option>
                                    @endif
                                @endforeach
                            </select>
                        </span>
                    </p>
                    <p>
                        <label>Status</label>
                        <span class="field">
                            <select name="status" id="status" required>
                                <option value="">---- Select Status ----</option>
                                @foreach(['active','inactive'] as $status)
                                    @if(Request::old('status')==$status)
                                        <option value="{{$status}}" selected>{{$status}}</option>
                                    @else
                                        <option value="{{$status}}">{{$status}}</option>
                                    @endif
                                @endforeach
                            </select>
                        </span>
                    </p>
                    <p>
                        <label>Members</label>
                        <span class="field">
                            <select name="members[]" id="members" multiple class="chzn-select-type">
                                <option value="" disabled>---- No Members ----</option>
                                <?php
                                $old=[];
                                if (!empty(Request::old('members'))){
                                    $old=Request::old('members');
                                }
                                ?>
                                @foreach($users as $user)
                                    @if(empty($user->team_id) && in_array($user->role_id,config('app.telecaller')))
                                        @if(in_array($user->id,$old))
                                            <option value="{{$user->id}}" selected>{{$user->getFullNameAttribute()}}</option>
                                        @else
                                            <option value="{{$user->id}}">{{$user->getFullNameAttribute()}}</option>
                                        @endif
                                    @endif
                                @endforeach
                            </select>
                        </span>
                    </p>
                    <p class="stdformbutton">
                        <button type="submit" class="btn btn-primary">Submit</button>
                        <button type="reset" class="btn">Reset</button>
                    </p>
                </form>
            </div>



            <div class="divider15"></div>

        </div><!--span8-->

    </div><!--row-fluid-->
@endsection
@pushOnce('scripts')
<script>
    jQuery(function ($) {
        $('.chzn-select-type').chosen();
        $('#parent_id').change(function () {
            var $child=$('#child_teams');
            $child.find('option').prop('disabled',false);
            $child.find('option[value="'+$(this).val()+'"]').prop('disabled',true);
            $child.trigger('liszt:updated');
        });
    },jQuery);
</script>
@endPushOnce


