@extends('admin/layout')

@section('content')
    <script type="text/javascript" src="{{ asset('/katniss/js/chosen.jquery.min.js')}}"></script>
    <div class="row-fluid">
        <div class="span12">


            <div class="widgetcontent">
                <a class="btn btn-primary writeonly" href="{{ url('/'.getCurrentUrlPrefix().'/create') }}">Add New</a> &nbsp; &nbsp; &nbsp;
                <a class="btn btn-primary" href="{{ url('/'.getCurrentUrlPrefix()) }}">View All</a>

            </div>
            <!-- if there are creation errors, they will show here -->
            @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> There were some problems with your input.<br>

                    @foreach ($errors->all() as $error)
                        <p>{{ $error }}</p>
                    @endforeach

                </div>
            @endif
            @if (Session::has('message'))
                <div class="alert alert-info">{{ Session::get('message') }}</div>
            @endif
            <h4 class="widgettitle nomargin shadowed">&nbsp;</h4>
            <div class="widgetcontent bordered shadowed nopadding">
                {!! Form::open(array('url' => array('administrator/team-management', $team->id), 'method' => 'PUT','class'=>'stdform stdform2','enctype'=>'multipart/form-data')) !!}
                    <p>
                        <label>Parent</label>
                        <span class="field">
                            <select name="parent_id" id="parent_id">
                                <option value="">---- No Parent ----</option>
                                @if($team->is_root!=1)
                                @foreach($parents as $parent)
                                    @if(!empty($team->parents()->first()->id) && $team->parents()->first()->id==$parent->id)
                                        <option value="{{$parent->id}}" selected>{{$parent->team_name}}</option>
                                    @else
                                        <option value="{{$parent->id}}">{{$parent->team_name}}</option>
                                    @endif
                                @endforeach
                                @endif
                            </select>
                        </span>
                    </p>
                    <p>
                        <label>Team Name</label>
                        <span class="field">
                            <input type="text" name="team_name" value="{{$team->team_name}}" id="team_name" class="input-xxlarge alpha_dash" required>
                        </span>
                    </p>
                <p>
                    <label for="">Team Type</label>
                    <span class="field">
                            <select name="teamTypes[]" id="teamTypes"  class="chzn-select-type" multiple="multiple" style="width:350px;" tabindex="4" required>
                                <?php
                                $teamTypesForTeam=$team->teamTypes()->get();
                                $teamTypesArray=[];
                                if ($teamTypesForTeam->count()>0){
                                    foreach ($teamTypesForTeam as $value){
                                        $teamTypesArray[]=$value->id;
                                    }
                                }
                                ?>
								@foreach($teamTypes as $key => $teamType)
                                    @if(in_array($teamType->id,$teamTypesArray))
                                        <option value="{{ $teamType->id }}" selected>{{ $teamType->team_type}}</option>
                                    @else
                                            <option value="{{ $teamType->id }}">{{ $teamType->team_type}}</option>
                                        @endif
                                @endforeach
                            </select>
                        </span>
                </p>
                    <p>
                        <label>Status</label>
                        <span class="field">
                            <select name="status" id="status" required>
                                <option value="">---- Select Status ----</option>
                                @foreach(['active','inactive'] as $status)
                                    @if($team->status==$status)
                                        <option value="{{$status}}" selected>{{$status}}</option>
                                    @else
                                        <option value="{{$status}}">{{$status}}</option>
                                    @endif
                                @endforeach
                            </select>
                        </span>
                    </p>
                    <p class="stdformbutton">
                        <button type="submit" class="btn btn-primary">Submit</button>
                        <button type="reset" class="btn">Reset</button>
                    </p>
                </form>
            </div>



            <div class="divider15"></div>

        </div><!--span8-->

    </div><!--row-fluid-->

    <script>
        jQuery('.chzn-select-type').chosen();
    </script>
@endsection

