@extends('layouts.app')

@section('content')
    <div class="container-fluid">
        <div class="span12">

            @if (Session::has('message'))
                <div class="alert alert-info">{{ Session::get('message') }}</div>
            @endif
            <div class="widgetcontent">
                <div class="d-sm-flex align-items-center justify-content-between mb-4">
                    <h1 class="h3 mb-0 text-gray-800">Users</h1>
                    <div class="row">
                        <div class="col-md-6">
                            <a class="btn btn-primary writeonly" href="{{ url('/users/team-management/create') }}">Add New</a>
                        </div>
                        <div class="col-md-6">
                            <a class="btn btn-primary" href="{{ url('/users/team-management') }}">View All</a>
                        </div>

                    </div>

                </div>

                <table class="table table-bordered" id="dyntable">

                    <thead>
                    <tr>
                        <th class="head0 nosort">Team Id</th>
                        <th class="head0">Parent</th>
                        <th class="head0">Team</th>
                    </tr>
                    </thead>
                    <tbody>
                    @if(!empty($teams))
                        @foreach($teams as $key => $team)
                            <tr>
                                <td class="aligncenter">
                                    <span class="center">
                                        {{$team['id']}}
                                    </span>
                                </td>
                                <td>
                                    @php
                                        if($team['is_root']==1){
                                            echo "Root Team";
                                        }else if(!empty($team['parent_id'])){
                                            echo $team['parents']['team_name'];
                                        }
                                    @endphp
                                </td>
                                <td>{{ $team['team_name'] }}</td>
                            </tr>
                        @endforeach
                    @endif
                    </tbody>
                </table>
            </div>

            <div class="divider15"></div>

        </div><!--span8-->

    </div><!--row-fluid-->
@endsection
@pushOnce('styles')
<link rel="stylesheet" href="{{ asset('admin/vendor/datatables/dataTables.bootstrap4.min.css') }}">
@endPushOnce
@pushOnce('scripts')
<script type="text/javascript" src="{{ asset('/admin/vendor/datatables/jquery.dataTables.min.js') }}"></script>
<style type="text/css">
    .dataTables_info{
        margin-top:2%;
    }

</style>
<script>
    if(jQuery('#dyntable').length > 0) {
        jQuery('#dyntable').DataTable();
    }
</script>
@endPushOnce