@extends('admin/layout')

@section('content')

    <div class="row-fluid">
        <div class="span12">


            <div class="widgetcontent">
                <a class="btn btn-primary writeonly" href="{{ url('/'.getCurrentUrlPrefix().'//team-management/create') }}">Add New</a> &nbsp; &nbsp; &nbsp;
                <a class="btn btn-primary" href="{{ url('/administrator/team-management') }}">View All</a>

            </div>
            <div class="span8">

                <table class="table table-bordered table-invoice">
                    <tbody>
                    <tr>
                        <td class="width30">Team Id</td>
                        <td class="width70"><strong>{{$team->id}}</strong></td>
                    </tr>
                    <tr>
                        <td class="width30">Parent</td>
                        <td class="width70"><strong>{{!empty($team->parents()->first()->team_name)?$team->parents()->first()->team_name:''}}</strong></td>
                    </tr>
                    <tr>
                        <td class="width30">Team Name</td>
                        <td class="width70"><strong>{{$team->team_name}}</strong></td>
                    </tr>
                    <tr>
                        <td class="width30">Team Type</td>
                        <?php
                        $teamTypesForTeam=$team->teamTypes()->get();
                        $teamTypesArray=[];
                        if ($teamTypesForTeam->count()>0){
                            foreach ($teamTypesForTeam as $value){
                                $teamTypesArray[]=$value->team_type;
                            }
                        }
                        ?>
                        <td class="width70"><strong>{{implode(', ',$teamTypesArray)}}</strong></td>
                    </tr>
                    <tr>
                        <td class="width30">Status</td>
                        <td class="width70"><strong>{!! $team->status !!}</strong></td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="divider15"></div>

        </div><!--span8-->

    </div><!--row-fluid-->


@endsection

