@extends('layouts.app')

@section('content')
    <div class="container-fluid">
        <div class="span12">

            @if (Session::has('message'))
                <div class="alert alert-info">{{ Session::get('message') }}</div>
            @endif
            <div class="widgetcontent">
                <div class="d-sm-flex align-items-center justify-content-between mb-4">
                    <h1 class="h3 mb-0 text-gray-800">Team Structure</h1><br/>
                </div>
                <table class="table table-bordered" id="dyntable">
                    @php
                        $traverse = function ($categories, $prefix = '--') use (&$traverse) {
                        foreach ($categories as $category) {
                            echo "<tr><td>".$prefix;
                            if($category->role_id==3){
                                echo '<b style="color:green;">'.$category->getFullNameAttribute().'</b>';
                            }else{
                                echo $category->getFullNameAttribute();
                            }
                            echo "</td></tr>";
                            $traverse($category->children, $prefix.'--');
                        }
                        };

                        $traverse($nodes);
                    @endphp
                </table>
            </div>

            <div class="divider15"></div>

        </div><!--span8-->

    </div><!--row-fluid-->
@endsection