@extends('admin/layout')

@section('content')
    <link rel="stylesheet" href="{{url('/katniss/tree/jquery.bonsai.css')}}"/>
    <script
            src="https://code.jquery.com/jquery-3.2.1.min.js"
            integrity="sha256-hwg4gsxgFZhOsEEamdOYGBf13FyQuiTwlAQgxVSNgt4="
            crossorigin="anonymous"></script>
    <script type="text/javascript" src="{{ asset('/katniss/js/chosen.jquery.min.js')}}"></script>
    <script src="{{url('/katniss/tree/jquery.bonsai.js')}}"></script>
    <link rel="stylesheet" href="{{asset('/katniss/autofill/css/autofill.css')}}">
    <script type="text/javascript" src="{{asset('/katniss/autofill/js/autofill.js')}}"></script>
    <style>
        #tree {
            width: 350px;
        }

        .parents {
            /*border: 1px solid black;*/
            padding: 2px;
            cursor: pointer;
        }

        .parents:hover {
            /*background-color: #727272;*/
            /*color: #ffffff;*/
        }
        .chzn-container .chzn-results {
            max-height:100px;
        }
        .modal-body{
            overflow-y: hidden;
        }
    </style>
    <div class="widgetcontent">
        <a class="btn btn-primary writeonly" href="{{ url('/'.getCurrentUrlPrefix().'/create') }}">Add New</a> &nbsp;
        &nbsp; &nbsp;
        <a class="btn btn-primary" href="{{ url('/'.getCurrentUrlPrefix()) }}">View All</a>&nbsp; &nbsp;
        <a class="btn btn-primary" href="{{ url('/'.getCurrentUrlPrefix()."/create-hierarchy") }}">Create Hierarchy</a>
    </div>

    <h4 class="widgettitle nomargin shadowed">Filter</h4>
<br>

        <div class="row-fluid">

            <form  method="get" class="search-filter">


                    <?php $selectedUserId=null;$selectedUserName=null; $t=[];?>

                    @if(isset($usersSearch) and !empty($usersSearch))
                        @foreach($usersSearch as $key => $value)

                            @if(base64_encode($value['id'])==html_entity_decode(Input::get('uid')))
                                <?php
                                $selectedUserId=base64_encode($value['id']);
                                $selectedUserName=$value['name'];
                                ?>
                            @endif
                            <?php $u[]=['label'=>$value['name'],'value'=>($value['id'])];
                            // pr($u);die;
                            ?>
                        @endforeach
                    @endif


                <input type="search" placeholder="Select User" value="{{empty($selectedUserName)?'':$selectedUserName}}" id="uid" autocomplete="off" class="span2 input-small " data-autofill="{{@json_encode($u)}}">
                <input type="hidden" value="{{empty($selectedUserId)?'':$selectedUserId}}" class="autofillchange" name="uid" id="uid-hidden">
                        <button type="submit" id="submit" value="submit">Submit</button>
                    <div class="show-data"></div>




                <br>

            </form>


        </div>
<br>
<br>
<br>

    <div class="row-fluid">
        <div class="span6">

            <h4 class="widgettitle nomargin shadowed">Manage Teams</h4>

            <div class="widgetcontent bordered shadowed nopadding">
                <ol id="tree">
                    @foreach($teams as $team)
                        <?php
                        try {
                            $teamTypesForTeam = $team->teamTypes()->get();
                            $teamTypesArray = [];
                            if ($teamTypesForTeam && $teamTypesForTeam->count() > 0) {
                                foreach ($teamTypesForTeam as $key => $value) {
                                    if (!empty($value->team_type))
                                        $teamTypesArray[] = $value->team_type;
                                }
                            }
                        } catch (Throwable $ex) {
                            echo $ex->getMessage();
                            die;
                        }

                        ?>
                        <li id="team_{{$team->id}}" data-id="{{$team->id}}" class="parents li-of-tree"
                            data-name="{{$team->team_name}}" data-lead="{{$team->team_lead}}"
                            data-type="{{implode(',',$teamTypesArray)}}" data-status="{{$team->status}}" data-parent=""
                            data-is_root="{{$team->is_root}}"><span class="icon icon-th"></span> {{$team->team_name}} [T]<span class="pull-right"><span
                                        class="icon icon-plus add-team" data-edit="{{$team->id}}" data-toggle="tooltip"
                                        title="Add Team"></span> <span class="icon icon-user add-user"
                                                                       data-edit="{{$team->id}}" data-toggle="tooltip"
                                                                       title="Add User"></span> {!! ($team->is_root!=1)?'<span class="icon icon-move move-team" data-edit="'.$team->id.'" data-toggle="tooltip" title="Move Team"></span> <span class="icon icon-remove remove-team" data-edit="'.$team->id.'" data-toggle="tooltip" title="Remove Team"></span>':'' !!}</span>
                        </li>
                        <?php unset($teamTypesArray);?>
                    @endforeach
                </ol>
            </div>
            <div class="divider15"></div>

        </div>
        <div class="span6 update-team">

            <h4 class="widgettitle nomargin shadowed">Update <span id="typeOfEdit"></span></h4>
            <div class="widgetcontent bordered shadowed nopadding edit-form">
                <form class="stdform stdform2" action="" id="edit-form" method="POST" accept-charset="UTF-8">
                    {{--<input name="_method" value="PUT" autocomplete="off" type="hidden">--}}
                    <input type="hidden" name="_token" value="{{csrf_token()}}">
                    <input type="hidden" name="manage" value="1">
                    {{--<p>
                        <label>Parent</label>
                        <span class="field">
                            <select name="parent_id" id="team_parent_id_edit">
                                <option value="">---- No Parent ----</option>
                                @foreach($allTeams as $parent)
                                    <option value="{{$parent->id}}">{{$parent->team_name}}</option>
                                @endforeach
                            </select>
                        </span>
                    </p>--}}
                    <p>
                        <label for="team_name_edit">Team Name</label>
                        <span class="field">
                            <input type="text" id="team_name_edit" name="team_name" required>
                        </span>
                    </p>
                    <p>
                        <label for="team_lead_edit">Team Lead</label>
                        <span class="field">
                            <select name="team_lead" id="team_lead_edit" required>
                                <?php $usersInList=[];?>
                                @foreach($users as $user)
                                    @if(in_array($user->role,config('app.team_lead')) && !in_array($user->id,$allTeamLeads))
                                        <?php
                                            $usersInList[$user->id]=$user->name;
                                        ?>
                                        <option value="{{$user->id}}">{{$user->name}}</option>
                                    @endif
                                @endforeach
                            </select>
                        </span>
                    </p>
                    <p>
                        <label for="">Reportee Teams</label>
                    <div id="team_reportee_tree" class="field">
                        <ol id="reportee_tree">

                        </ol>
                    </div>
                    </p>
                    <p>
                        <label for="team_type_edit">Team Type</label>
                        <span class="field">
                            <select name="teamTypes[]" id="team_type_edit" multiple required>
                                @foreach($teamTypes as $teamType)
                                    <option value="{{$teamType->id}}">{{$teamType->team_type}}</option>
                                @endforeach
                            </select>
                        </span>
                    </p>
                    {{--<p>
                        <label>Status</label>
                        <span class="field">
                            <select name="status" id="team_status_edit" required>
                                @foreach(['active','inactive'] as $status)
                                    <option value="{{$status}}">{{$status}}</option>
                                @endforeach
                            </select>
                        </span>
                    </p>--}}
                    <p class="stdformbutton">
                        <button id="edit-form-submit-button" type="submit" class="btn btn-primary">Submit</button>
                    </p>
                </form>
            </div>
            <div class="divider15"></div>
        </div>
        <!--span8-->
        <div id="addTeam" class="modal hide">
            <div class="modal-header">
                <button class="close" data-dismiss="modal">X</button>
                <h3>Add team</h3>
            </div>
            <div class="modal-body">
                <p id="team-response-message" class="text-success"></p>
                <form id="updateTeam" action="{{url('/')}}" class="stdform stdform2">
                    <p>
                        <label for="status">Teams</label>
                        <span class="field">
                            <select name="teams[]" id="teams-list" multiple>
                                @foreach($teams as $team)
                                    @if($team->is_root!=1)
                                        <option value="{{$team->id}}">{{$team->team_name}}</option>
                                    @endif
                                @endforeach
                            </select>
                            <br>
                            <span id="teams-list-error" class="alert-error"></span>
                        </span>
                    </p>
                    <p class="stdformbutton">
                        <input type="hidden" value="{{csrf_token()}}" name="_token">
                        <input type="hidden" id="parent-team-id" name="parent_id">
                        <button class="btn btn-primary">Submit</button>
                        <button type="reset" class="hide resetButton"></button>
                    </p>
                </form>
            </div>
        </div>
        <div id="addUser" class="modal hide">
            <div class="modal-header">
                <button class="close" data-dismiss="modal">X</button>
                <h3>Add User</h3>
            </div>
            <div class="modal-body">
                <p id="user-response-message" class="text-success"></p>
                <form id="updateUser" action="{{url('/')}}" class="stdform stdform2">
                    <p>
                        <label for="status">Users</label>
                        <span class="field">
                            <select name="users[]" id="user-list" multiple>
                                @foreach($users as $user)
                                    @if(in_array($user->role,config('app.telecaller')) && empty($user->team_id))
                                        <option value="{{$user->id}}">{{$user->name}}</option>
                                    @endif
                                @endforeach
                            </select>
                            <br>
                            <span id="user-list-error" class="alert-error"></span>
                        </span>
                    </p>
                    <p class="stdformbutton">
                        <input type="hidden" value="{{csrf_token()}}" name="_token">
                        <input type="hidden" id="parent-team-user-id" name="parent_team_id">
                        <button class="btn btn-primary">Submit</button>
                        <button type="reset" class="hide resetButton"></button>
                    </p>
                </form>
            </div>
        </div>
        <div id="moveUser" class="modal hide">
            <div class="modal-header">
                <button class="close" data-dismiss="modal">X</button>
                <h3>Move User</h3>
            </div>
            <div class="modal-body">
                <p id="move-response-message" class="text-success"></p>
                <form id="moveTheUser" action="{{url('/')}}" class="stdform stdform2">
                    <p>
                        <label for="status">Team</label>
                        <span class="field">
                            <select name="team" id="single-team-list" required>
                                @foreach($allTeams as $team)
                                    <option value="{{$team->id}}">{{$team->team_name}}</option>
                                @endforeach
                            </select>
                            <br>
                            <span id="single-team-list-error" class="alert-error"></span>
                        </span>
                    </p>
                    <p class="stdformbutton">
                        <input type="hidden" value="{{csrf_token()}}" name="_token">
                        <input type="hidden" id="user-id" name="user_id">
                        <button class="btn btn-primary">Submit</button>
                        <button type="reset" class="hide resetButton"></button>
                    </p>
                </form>
            </div>
        </div>
        <div id="moveTeam" class="modal hide">
            <div class="modal-header">
                <button class="close" data-dismiss="modal">X</button>
                <h3>Move Team</h3>
            </div>
            <div class="modal-body">
                <p id="move-team-response-message" class="text-success"></p>
                <form id="moveTheTeam" action="{{url('/')}}" class="stdform stdform2">
                    <p>
                        <label for="status">Team</label>
                        <span class="field">
                                <select name="team" id="all-team-list" required>
                                    @foreach($allTeams as $team)
                                        <option value="{{$team->id}}">{{$team->team_name}}</option>
                                    @endforeach
                                </select>
                                <br>
                                <span id="all-team-list-error" class="alert-error"></span>
                            </span>
                    </p>
                    <p class="stdformbutton">
                        <input type="hidden" value="{{csrf_token()}}" name="_token">
                        <input type="hidden" id="team-id" name="team_id">
                        <button class="btn btn-primary">Submit</button>
                        <button type="reset" class="hide resetButton"></button>
                    </p>
                </form>
            </div>
        </div>
    </div><!--row-fluid-->
<?php
        $userArray=[];
    foreach ($users as $user){
        $userArray[$user->id]=$user->name;
    }
?>
    <script>
        $('#team').autofill({
            minScrollHeight:'100px',
            onSelect:function(object){

                $("#team-hidden").val(object.value);
            },
            onChange:function(query,objects,exactMatch){
                $('#uid-hidden').val('');
              $('#uid').val('');

                if(exactMatch.value!==undefined){

                    $('#team-hidden').val(exactMatch.value);
                }else{

                    $('#team-hidden').val('');
                }
            },

            render:function(object){
                var dataAttributes = '';
                var li = '';
                var arr = [];
                var attr=[];
                $(object).each(function (key, value) {
                    $.each(value, function (key, value) {
                        dataAttributes += ' data-' + key + '="' + value + '" ';

                    });
                    attr.push(dataAttributes);
                    dataAttributes='';
                    arr.push(value.label.trim());
                });
                attr = attr.sort();
                var qq =arr.sort();
                // console.log(qq.length);

                for (var i =0;i<qq.length;i++){
                    li += '<li class="autofill-list"' + attr[i] + '>' + qq[i] + '</li>';

                }

                return li;
            }

        });

        $('#uid').autofill({
            minScrollHeight:'50px',

            onSelect:function(object){


                $("#uid-hidden").val(object.value);

            },
            onChange:function(query,objects,exactMatch){
                $('#team-hidden').val('');
                $('#team').val('');

                if(exactMatch.value!==undefined){
                    $('#uid-hidden').val(exactMatch.value);
                }else{
                    $('#uid-hidden').val('');
                }
            },
            //sorting code
            render:function(object){
                var dataAttributes = '';
                var attr=[];
                var li = '';
                var arr = [];
                $(object).each(function (key, value) {
                    $.each(value, function (key, value) {
                        dataAttributes += ' data-' + key + '="' + value + '" ';
                    });
                    attr.push(dataAttributes);
                    dataAttributes='';
                    arr.push(value.label.trim());

                });
                attr = attr.sort();
                var qq =arr.sort();
                // console.log(qq.length);

                for (var i =0;i<qq.length;i++){
                    li += '<li class="autofill-list"' + attr[i] + '>' + qq[i] + '</li>';

                }

                return li;
            }

        });



$(document).on('click','#submit',function (e) {
    e.preventDefault();
    var userID=($('#uid-hidden').val());
   // alert((userID));//130
    $.ajax({
        url: '{{url("administrator/team-management/show-team-structure")}}'+'/'+userID,
        type: 'GET',

        success: function (response) {
            $('.show-data').html(response);
        }
    })
});

    </script>

    <script>
        var allUsers='{!! json_encode($userArray) !!}';
        var originalUsers='{!! json_encode($usersInList) !!}';
        allUsers=JSON.parse(allUsers);
        originalUsers=JSON.parse(originalUsers);
        var $tree = $('#tree');
        var $reporteeTeamTree = $('#reportee_tree');
        $reporteeTeamTree.bonsai();
        var bonsai = $tree.bonsai();
        $('.update-team').hide();
        $(document).on('click', '.li-of-tree', function (e) {
            if (e.target.nodeName === "LI") {
                $('.update-team').show();
                var $team = $(this);
                var teamId = $team.data('id');
                var lead= $team.data('lead');
                var $userList=$('#team_lead_edit');
                var originalOptions='';
                $.each(originalUsers,function (a, b) {
                    originalOptions+='<option value="'+a+'">'+b+'</option>';
                });
                $userList.html(originalOptions);
                var $option=$userList.find('option[value="'+lead+'"]');
                if($option.length<=0){
                    $userList.append('<option value="'+lead+'">'+allUsers[lead]+'</option>');
                }
                var checkForChild = $(document).find('ol#child-for-' + teamId);
                if (checkForChild.length <= 0){
                    $.ajax({
                        url: '{{url("administrator/team-management/get-team-child")}}' + '/' + teamId,
                        type: 'GET',
                        dataType: 'JSON',
                        success: function (response) {
                            if (response.status === '1') {
                                if (checkForChild.length <= 0) {
                                    var $child = $('<ol></ol>');
                                    $child.attr('id', 'child-for-' + teamId);
                                    $.each(response.child, function (a, b) {
                                        $child.append('<li class="li-of-tree" id="team_' + b.id + '" data-id="' + b.id + '" data-name="' + b.team_name + '" data-lead="' + b.team_lead + '" data-type="' + b.team_type + '" data-status="' + b.status + '" data-parent_id="' + b.parent_id + '" data-is_root="' + b.is_root + '"><span class="icon icon-th"></span>' + b.team_name + ' [T]<span class="pull-right"><span class="icon icon-plus add-team" data-edit="' + b.id + '" data-toggle="tooltip" title="Add Team"></span> <span class="icon icon-user add-user" data-edit="' + b.id + '" data-toggle="tooltip" title="Add User"></span> <span class="icon icon-move move-team" data-edit="' + b.id + '" data-toggle="tooltip" title="Move Team"></span> <span class="icon icon-remove remove-team" data-edit="' + b.id + '" data-toggle="tooltip" title="Remove Team"></span></span></li>');
                                    });
                                    $.each(response.members, function (a, b) {
                                        $child.append('<li class="li-of-member" id="team_member_' + b.id + '" data-id="' + b.id + '"><span class="icon icon-user"></span>' + b.name + ' [U]<span class="pull-right"><span class="icon icon-move move-user" data-edit="' + b.id + '" data-toggle="tooltip" title="Move User"></span> <span class="icon icon-remove remove-user" data-edit="' + b.id + '" data-toggle="tooltip" title="Remove User"></span></span></li>');
                                    });
                                    $team.append($child);
                                    $tree.bonsai('update');
                                    $reporteeTeamTree.bonsai('update');
                                    $team.find('div.thumb:first').click();
                                }
                            }
                        }
                    });
                }

                var data = $(this).data();
                var $firstLi = $('<li class="li-of-edit-tree parents" id="team_edit_' + data.id + '" data-id="' + data.id + '"><span class="icon icon-th"></span>' + data.name + '</li>');
                $reporteeTeamTree.html($firstLi);
                $('#edit-form').attr('action', '{{url('administrator/team-management')}}' + '/' + data.id + '/edit-team');
                var $parentIdField = $('#team_parent_id_edit');
                if (data.is_root == '1') {
                    $parentIdField.find('option').not('option:first').prop('disabled', true);
                } else {
                    $parentIdField.find('option').prop('disabled', false);
                }
                $parentIdField.val(data.parent_id);
                $('#team_name_edit').val(data.name);
                $userList.val(data.lead);
                var $teamType = $('#team_type_edit');
                var type = data.type.split(',');
                $teamType.find('option').prop('selected', false);
                $.each(type, function (a, b) {
                    $teamType.find('option').filter(function () {
                        if ($(this).text() === b) {
                            return $(this).prop('selected', true);
                        }
                    });
                });
                $teamType.trigger('liszt:updated');
                $('#team_status_edit').val(data.status);
                e.stopPropagation();
            }
        });
        $(document).on('click', '.li-of-edit-tree', function () {
            $('.update-team').show();
            var $team = $(this);
            var teamId = $team.data('id');
            var checkForChild = $(document).find('ol#child-edit-for-' + teamId);
            if (checkForChild.length <= 0) {
                $.ajax({
                    url: '{{url("administrator/team-management/get-team-child")}}' + '/' + teamId,
                    type: 'GET',
                    dataType: 'JSON',
                    success: function (response) {
                        if (response.status === '1') {
                            if (checkForChild.length <= 0) {
                                var $child = $('<ol></ol>');
                                $child.attr('id', 'child-edit-for-' + teamId);
                                $.each(response.child, function (a, b) {
                                    $child.append('<li class="li-of-edit-tree parents" id="team_edit_' + b.id + '" data-id="' + b.id + '" data-name="' + b.team_name + '" data-lead="' + b.team_lead + '" data-type="' + b.team_type + '" data-status="' + b.status + '" data-parent_id="' + b.parent_id + '" data-is_root="' + b.is_root + '"><span class="icon icon-th"></span>' + b.team_name + ' [T]</li>');
                                });
                                $.each(response.members, function (a, b) {
                                    $child.append('<li class="li-of-member" id="team_edit_member_' + b.id + '" data-id="' + b.id + '"><span class="icon icon-user"></span>' + b.name + ' [U]</li>');
                                });
                                $team.append($child);
                                $tree.bonsai('update');
                                $reporteeTeamTree.bonsai('update');
                                $team.find('div.thumb:first').click();
                            }
                        }
                    }
                });
            }
        });
        $(document).on('click', '.add-team', function () {
            $('#parent-team-id').val($(this).data('edit'));
            var $teamInput = $('#teams-list');
            $teamInput.val('');
            $('#teams-list-error').html('');
            $('#team-response-message').html('');
            $teamInput.find('option').prop('disabled', false);
            $teamInput.find('option[value="' + $(this).data('edit') + '"]').prop('disabled', true);
            $teamInput.trigger('liszt:updated');
            $('#addTeam').show();
        });
        $(document).on('click', '.add-user', function () {
            $('#parent-team-user-id').val($(this).data('edit'));
            var $userInput = $('#user-list');
            $userInput.val('');
            $userInput.trigger('liszt:updated');
            $('#user-list-error').html('');
            $('#user-response-message').html('');
            $('#addUser').show();
        });
        $(document).on('click', '.move-user', function () {
            $('#user-id').val($(this).data('edit'));
            var $team = $('#single-team-list');
            $team.val('');
            $team.trigger('liszt:updated');
            $('#single-team-list-error').html('');
            $('#move-response-message').html('');
            $('#moveUser').show();
        });
        $(document).on('click', '.move-team', function () {
            $('#team-id').val($(this).data('edit'));
            var $team = $('#all-team-list');
            $team.val('');
            $team.find('option').prop('disabled', false);
            $team.find('option[value="' + $(this).data('edit') + '"]').prop('disabled', true);
            $('#all-team-list-error').html('');
            $('#move-team-response-message').html('');
            $('#moveTeam').show();
        });
        $(document).on('click', '.remove-user', function () {
            var action = confirm('Are you sure you want to remove this user?');
            var userId = $(this).data('edit');
            if (action) {
                $.ajax({
                    url: '{{url('administrator/team-management/remove-user')}}',
                    data: {
                        _token: '{{csrf_token()}}',
                        user: userId
                    },
                    type: 'POST',
                    dataType: 'JSON',
                    success: function (response) {
                        alert(response.message);
                        window.location.reload();
                    }
                });
            }
        });
        $(document).on('click', '.remove-team', function () {
            var action = confirm('Are you sure you want to remove this team?');
            var teamId = $(this).data('edit');
            if (action) {
                $.ajax({
                    url: '{{url('administrator/team-management/remove-team')}}',
                    data: {
                        _token: '{{csrf_token()}}',
                        team_id: teamId
                    },
                    type: 'POST',
                    dataType: 'JSON',
                    success: function (response) {
                        alert(response.message);
                        window.location.reload();
                    }
                });
            }
        });
        $(document).on('click', '.close', function () {
            var $div = $(this).parents('div.modal').hide();
        });
        $('#teams-list').chosen();
        $('#user-list').chosen();
        $('#team_type_edit').chosen();
        $('#updateTeam').submit(function (e) {
            e.preventDefault();
            var $form = $(this);
            var $teamInput = $('#teams-list');
            var teams = $teamInput.val();
            if (teams.length > 0) {
                $.ajax({
                    url: '{{url('administrator/team-management/add-child-teams')}}',
                    type: 'POST',
                    data: $form.serialize(),
                    dataType: 'JSON',
                    success: function (response) {
                        $('#team-response-message').html(response.message);
                        window.location.reload();
                    }
                });
            } else {
                $('#' + $teamInput.attr('id') + '-error').html('Please Select a team.');
            }
        });
        $('#updateUser').submit(function (e){
            e.preventDefault();
            var $form = $(this);
            var $userInput = $('#user-list');
            var users = $userInput.val();
            if (users.length > 0) {
                $.ajax({
                    url: '{{url('administrator/team-management/add-members')}}',
                    type: 'POST',
                    data: $form.serialize(),
                    dataType: 'JSON',
                    success: function (response){
                        $('#user-response-message').html(response.message);
                        window.location.reload();
                    }
                });
            } else {
                $('#' + $userInput.attr('id') + '-error').html('Please Select a user.');
            }
        });
        $('#moveTheUser').submit(function (e) {
            e.preventDefault();
            var $form = $(this);
            var $teamInput = $('#single-team-list');
            var users = $teamInput.val();
            if (users.length > 0) {
                $.ajax({
                    url: '{{url('administrator/team-management/move-member')}}',
                    type: 'POST',
                    data: $form.serialize(),
                    dataType: 'JSON',
                    success: function (response) {
                        $('#move-response-message').html(response.message);
                        window.location.reload();
                    }
                });
            } else {
                $('#' + $teamInput.attr('id') + '-error').html('Please Select a team.');
            }
        });
        $('#moveTheTeam').submit(function (e) {
            e.preventDefault();
            var $form = $(this);
            var $teamInput = $('#all-team-list');
            var teams = $teamInput.val();
            if (teams.length > 0) {
                $.ajax({
                    url: '{{url('administrator/team-management/move-team')}}',
                    type: 'POST',
                    data: $form.serialize(),
                    dataType: 'JSON',
                    success: function (response) {
                        $('#move-team-response-message').html(response.message);
                        window.location.reload();
                    }
                });
            } else {
                $('#' + $teamInput.attr('id') + '-error').html('Please Select a team.');
            }
        });
        $(document).on('click','#edit-form-submit-button',function () {
            var $teamType=$('#team_type_edit');
            if($teamType.val().length<=0){
                $(document).find('#team_type_edit_chzn').after('<p style="border-top:none;color:red;">This field is required</p>')
            }
        });
    </script>
@endsection

