<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

use App\Http\Controllers\HomeController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('clear_cache', function () {

    \Artisan::call('cache:clear');

    dd("Cache is cleared");

});
Route::get('/', function () {
    return redirect()->route('login');
});

Auth::routes(['register' => false]);

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

// Profile Routes
Route::prefix('profile')->name('profile.')->middleware('auth')->group(function(){
    Route::get('/', [HomeController::class, 'getProfile'])->name('detail');
    Route::post('/update', [HomeController::class, 'updateProfile'])->name('update');
    Route::post('/change-password', [HomeController::class, 'changePassword'])->name('change-password');
});

// Roles
Route::resource('roles', App\Http\Controllers\RolesController::class);

// Permissions
Route::resource('permissions', App\Http\Controllers\PermissionsController::class);

// Users 
Route::middleware('auth')->prefix('users')->name('users.')->group(function(){
    Route::get('/', [UserController::class, 'index'])->name('index');
    Route::get('/create', [UserController::class, 'create'])->name('create');
    Route::post('/store', [UserController::class, 'store'])->name('store');
    Route::get('/edit/{user}', [UserController::class, 'edit'])->name('edit');
    Route::put('/update/{user}', [UserController::class, 'update'])->name('update');
    Route::delete('/delete/{user}', [UserController::class, 'delete'])->name('destroy');
    Route::get('/update/status/{user_id}/{status}', [UserController::class, 'updateStatus'])->name('status');
    Route::get('/import-users', [UserController::class, 'importUsers'])->name('import');
    Route::post('/upload-users', [UserController::class, 'uploadUsers'])->name('upload');
    Route::get('export/', [UserController::class, 'export'])->name('export');

    //Route::get('team-management', [UserController::class, 'export'])->name('export');

});

Route::group(array('module' => 'cms', 'namespace' => 'App\modules\backend\cms\Controllers', 'prefix' => 'users', 'middleware' => array('auth'), 'after' => 'no-cache'), function () {
        //Route::post('team-management/create', 'TeamManagementController@store');
        //Route::resource('team-management', 'TeamManagementController');
        Route::get('team-structure', 'TeamManagementController@printTeams');
});
Route::group(array('module' => 'cms', 'namespace' => 'App\modules\backend\cms\Controllers', 'prefix' => 'leads', 'middleware' => array('auth'), 'after' => 'no-cache'), function () {
    //Health Leads
    Route::get('health','LeadsController@healthLeads')->name('leads.health_leads');
    Route::post('health/update-leads','LeadsController@updateHealthLeads');
    Route::get('health/view/{id}','LeadsController@viewHealthLeads');
    Route::post('health/assignlead','LeadsController@assignLeads');


    //Life Leads
    Route::get('life','LifeLeadsController@getLeads')->name('leads.life_leads');
    Route::post('life/update-leads','LifeLeadsController@updateLeads');
    Route::get('life/view/{id}','LifeLeadsController@viewhLeads');
    Route::post('life/assignlead','LifeLeadsController@assignLeads');

    //Motor Leads
    Route::get('motor','MotorLeadsController@getLeads')->name('leads.motor_leads');
    Route::post('motor/update-leads','MotorLeadsController@updateLeads');
    Route::get('motor/view/{id}','MotorLeadsController@viewhLeads');
    Route::post('motor/assignlead','MotorLeadsController@assignLeads');


    //Investment Leads
    Route::get('investment','investmentLeadsController@getLeads')->name('leads.investment_leads');
    Route::post('investment/update-leads','investmentLeadsController@updateLeads');
    Route::get('investment/view/{id}','investmentLeadsController@viewhLeads');
    Route::post('investment/assignlead','investmentLeadsController@assignLeads');

});

Route::group(array('module' => 'cms', 'namespace' => 'App\modules\backend\cms\Controllers', 'prefix' => 'operations', 'middleware' => array('auth'), 'after' => 'no-cache'), function () {
    //Health Operations
    Route::get('health/add/{id}', 'healthOperationsController@addBooking');
    Route::get('health/edit/{id}', 'healthOperationsController@editBooking');
    Route::get('health/view/{id}', 'healthOperationsController@viewBooking');
    Route::post('health/save/{id}', 'healthOperationsController@saveBooking');
    Route::post('health/update/{id}', 'healthOperationsController@updateBooking');
    Route::post('health/update-status', 'healthOperationsController@updateLeadOperationStatus');
    Route::get('health', 'healthOperationsController@index')->name('operations.health');


    //Life Operations
    Route::get('life/add/{id}', 'lifeOperationsController@addBooking');
    Route::get('life/edit/{id}', 'lifeOperationsController@editBooking');
    Route::get('life/view/{id}', 'lifeOperationsController@viewBooking');
    Route::post('life/save/{id}', 'lifeOperationsController@saveBooking');
    Route::post('life/update/{id}', 'lifeOperationsController@updateBooking');
    Route::post('life/update-status', 'lifeOperationsController@updateLeadOperationStatus');
    Route::get('life', 'lifeOperationsController@index')->name('operations.life');

});
